namespace gov.va.med.vbecs.Common
{
    #region Header
    ///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
    ///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
    ///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
    ///<Developers>
    ///	<Developer>Carrie Van Stedum</Developer>
    ///</Developers>
    ///<SiteName>Hines OIFO</SiteName>
    ///<CreationDate>03/12/2003</CreationDate>
    ///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
    /// <summary>
    /// Enum that's used to update the LastUpdateFunctionId column in the tables
    /// </summary>
    /// 
    #endregion
	public enum UpdateFunction
	{
		/// <summary>
		/// Invalid = -1
		/// </summary>
		Invalid = -1,
		/// <summary>
		/// UC023DlgMaintainAntibodies = 0
		/// </summary>
		UC023DlgMaintainAntibodies = 0,
		/// <summary>
		/// UC041DlgSelectSpecificities = 1
		/// </summary>
		UC041DlgSelectSpecificities = 1,
		/// <summary>
		/// UC001FrmProcessShipmentIn = 2
		/// </summary>
		UC001FrmProcessShipmentIn = 2,
		/// <summary>
		/// UC011FrmProcessShipmentOut = 3
		/// </summary>
		UC011FrmProcessShipmentOut = 3,
		/// <summary>
		/// UC002FrmAboRHConfirmProcess = 4
		/// </summary>
		UC002FrmAboRHConfirmProcess = 4,
		/// <summary>
		/// UC056FrmRecordTesting = 5
		/// </summary>
		UC056FrmRecordTesting = 5,
		/// <summary>
		/// UC003FrmSelectUnitsForPatient = 6
		/// </summary>
		UC003FrmSelectUnitsForPatient = 6,
		/// <summary>
		/// SpecialTestingSaveCmvNegStatus = 7
		/// </summary>
		SpecialTestingSaveCmvNegStatus = 7,
		/// <summary>
		/// SpecialTesting_SaveSickleCellStatus = 8
		/// </summary>
		SpecialTestingSaveSickleCellStatus = 8,
		/// <summary>
		/// UC041FrmRecordPhenotypeResults = 9
		/// </summary>
		UC041FrmRecordPhenotypeResults = 9,
		/// <summary>
		/// UC031FrmMaintainComments = 10
		/// </summary>
		UC031FrmMaintainComments = 10,
		/// <summary>
		/// UC050FrmConfigureComponents = 11
		/// </summary>
		UC050FrmConfigureComponents = 11,
		/// <summary>
		/// UC051FrmConfigureReagent = 12
		/// </summary>
		UC051FrmConfigureReagent = 12,
		/// <summary>
		/// UC009DlgMaintainDivision = 13
		/// </summary>
		UC009DlgMaintainDivision = 13,
		/// <summary>
		/// UC027FrmDiscardQuarantine = 14
		/// </summary>
		UC027FrmDiscardQuarantine = 14,
		/// <summary>
		/// UC017FrmEditInvoiceText = 15
		/// </summary>
		UC017FrmEditInvoiceText = 15,
		/// <summary>
		/// UC034FrmMaintainComplications = 16
		/// </summary>
		UC034FrmMaintainComplications = 16,
		/// <summary>
		/// UC033FrmDefineEffectivenessTests = 17
		/// </summary>
		UC033FrmDefineEffectivenessTests = 17,
		/// <summary>
		/// UC006FrmCollectionFacilityMaintain = 18
		/// </summary>
		UC006FrmCollectionFacilityMaintain = 18,
		/// <summary>
		/// UC026FrmModifyUnits = 19
		/// </summary>
		UC026FrmModifyUnits = 19,
		/// <summary>
		/// UC024FrmPoolUnits = 20
		/// </summary>
		UC024FrmPoolUnits = 20,
		/// <summary>
		/// UC024FrmSplitUnits = 21
		/// </summary>
		UC025FrmSplitUnits = 21,
		/// <summary>
		/// UC032DlgMaintainMsbos = 22
		/// </summary>
		UC032DlgMaintainMsbos = 22,
		/// <summary>
		/// UC045FrmOrderSpecimenReflex = 23
		/// </summary>
		UC045FrmOrderSpecimenReflex = 23,
		/// <summary>
		/// UC016FrmPendingOrderSearch = 24
		/// </summary>
		UC016FrmPendingOrderSearch = 24,
		/// <summary>
		/// UC035FrmMaintainSpecimen = 25
		/// </summary>
		UC035FrmMaintainSpecimen = 25,
		/// <summary>
		/// HL7CprsInterface = 26
		/// </summary>
		HL7CprsInterface = 26,
		/// <summary>
		/// UC028FrmRecordLotNumbers = 27
		/// </summary>
		UC028FrmRecordLotNumbers = 27,
		/// <summary>
		/// UC008FrmBloodProductEdit = 28
		/// </summary>
		UC008FrmBloodProductEdit = 28,
		/// <summary>
		/// UC028FrmDailyReagentRackQC = 29
		/// </summary>
		UC028FrmDailyReagentRackQC = 29,
		/// <summary>
		/// UC020FrmUpdateReagentInventory = 30
		/// </summary>
		UC020FrmUpdateReagentInventory = 30,
		/// <summary>
		/// UC058FrmMaintainReagentMinLevels = 31
		/// </summary>
		UC058FrmMaintainReagentMinLevels = 31,
		/// <summary>
		/// UC038FrmDefineTransfusionReqs = 32
		/// </summary>
		UC038FrmDefineTransfusionReqs = 32,
		/// <summary>
		/// UC019FrmUpdateUser = 33
		/// </summary>
		UC019FrmUpdateUser = 33,
		/// <summary>
		/// UC029FrmAssignWorkloadCodes = 34
		/// </summary>
		UC029FrmAssignWorkloadCodes = 34,
		/// <summary>
		/// UC011DlgShipmentOut = 35
		/// </summary>
		UC011DlgShipmentOut = 35,
		/// <summary>
		/// UC026DlgModifyUnits = 36
		/// </summary>
		UC026DlgModifyUnits = 36,
		/// <summary>
		/// UC072DlgCancelActiveOrderComment
		/// </summary>
		UC072DlgCancelActiveOrderComment = 37,
		/// <summary>
		/// AntigenTypingWeakDClearGrid = 38
		/// </summary>
		AntigenTypingWeakDClearGrid = 38,
		/// <summary>
		/// DataGridAboRHClearGrid = 39
		/// </summary>
		DataGridAboRHClearGrid = 39,
		/// <summary>
		/// DataGridAbsClearGrid = 40
		/// </summary>
		DataGridAbsClearGrid = 40,
		/// <summary>
		/// DataGridDatClearGrid = 41
		/// </summary>
		DataGridDatClearGrid = 41,
		/// <summary>
		/// DataGridDatC3ClearGrid = 42
		/// </summary>
		DataGridDatC3ClearGrid = 42,
		/// <summary>
		/// DataGridDatIgGClearGrid = 43
		/// </summary>
		DataGridDatIgGClearGrid = 43,
		/// <summary>
		/// UC001_FrmPatientSelect = 44
		/// </summary>
		UC001FrmPatientSelect = 44,
		/// <summary>
		/// UC020FrmLogInReagents = 45
		/// </summary>
		UC020FrmLogInReagents = 45,
		/// <summary>
		/// UC014FrmEditUnitFinancial = 46
		/// </summary>
		UC014FrmEditUnitFinancial = 46,
		/// <summary>
		/// UC070FrmEditUnitProcessingTestHarness = 47
		/// </summary>
		UC070FrmEditUnitProcessingTestHarness = 47,
		/// <summary>
		/// UC070FrmEditUnitProcessing = 48
		/// </summary>
		UC070FrmEditUnitProcessing = 48,
		/// <summary>
		/// UC013FrmInvalidateFinalStatus = 49
		/// </summary>
		UC013FrmInvalidateFinalStatus = 49,
		/// <summary>
		/// UC073drmIssueBloodComponents = 50
		/// </summary>
		UC073FrmIssueBloodComponents = 50,
		/// <summary>
		/// UC071FrmFreeDirectedUnit = 51
		/// </summary>
		UC071FrmFreeDirectedUnit = 51,
		/// <summary>
		/// UC047FrmReleaseUnits = 52
		/// </summary>
		UC047FrmReleaseUnits = 52,
		/// <summary>
		/// UC069FrmEnterPostTransfusionInfo = 53
		/// </summary>
		UC069FrmEnterPostTransfusionInfo = 53,
		/// <summary>
		/// UC069FrmAboIncompatibleTransfusion = 54
		/// </summary>
		UC069FrmAboIncompatibleTransfusion = 54,
		/// <summary>
		/// UC094FrmInvalidatePatientTestResults = 55
		/// </summary>
		UC094FrmInvalidatePatientTestResults = 55,
		/// <summary>
		/// HL7PatientUpdateInterface = 56
		/// </summary>
		HL7PatientUpdateInterface = 56,
		/// <summary>
		/// HL7PatientMergeInterface = 57
		/// </summary>
		HL7PatientMergeInterface = 57,
		/// <summary>
		/// UC100FrmJustifyAboRHChange = 58
		/// </summary>
		UC100FrmJustifyAboRHChange = 58,
		/// <summary>
		/// UC021_FrmTransfusionReactionWorkup = 59
		/// </summary>
		UC021_FrmTransfusionReactionWorkup = 59,
		/// <summary>
		/// UC059FrmReturnIssuedUnits = 60
		/// </summary>
		UC059FrmReturnIssuedUnits = 60,
		/// <summary>
		/// UC068_FrmMergePatients = 61
		/// </summary>
		UC068_FrmMergePatients = 61,
		/// <summary>
		/// DataGridXMatch = 62
		/// </summary>
		DataGridXMatch = 62,
		/// <summary>
		/// UC081_FrmLogInSupplies = 63
		/// </summary>
		UC081_FrmLogInSupplies = 63,
		/// <summary>
		/// UC081_FrmRecordSupplyUsage = 64
		/// </summary>
		UC081_FrmRecordSupplyUsage = 64,
		/// <summary>
		/// MUC01_EditVistALinkConnectionParameters = 65
		/// </summary>
		MUC01_EditVistALinkConnectionParameters = 65,
		/// <summary>
		/// MUC02_EditDivisionParameters = 66
		/// </summary>
		MUC02_EditDivisionParameters = 66, 
		/// <summary>
		/// MUC03_EditVbecsUserParameters = 67
		/// </summary>
		MUC03_EditVbecsUserParameters = 67,
		/// <summary>
		/// MUC04_EditInterfaceParameters = 68
		/// </summary>
		MUC04_EditInterfaceParameters = 68,
		/// <summary>
		/// UC022_FrmNewEquipment = 69
		/// </summary>
		UC022_FrmNewEquipment = 69,
		/// <summary>
		/// UC022_FrmMaintainEquipment = 70
		/// </summary>
		UC022_FrmMaintainEquipment = 70,
		/// <summary>
		/// UC078DlgFinalizeTrwReport = 71
		/// </summary>
		UC078DlgFinalizeTrwReport = 71,
		/// <summary>
		/// VbecsHL7ClientMonitor
		/// </summary>
		VbecsHL7ClientMonitor = 72,
		/// <summary>
		/// UC045_FrmOrderSpecimenReflex = 73
		/// </summary>
		UC045_FrmOrderSpecimenReflex = 73,
		/// <summary>
		/// VbecsScheduledReportRunner
		/// </summary>
		VbecsScheduledReportRunner = 74,
		/// <summary>
		/// LockingFunction
		/// </summary>
		LockingFunction = 75,
		/// <summary>
		/// DssExtract
		/// </summary>
		DssExtract = 76,
		/// <summary>
		/// UC0108_UpdatedPatients
		/// </summary>
		UC0108_UpdatedPatients = 77,
		/// <summary>
		/// BackgroundJob_ExpireOrders
		/// </summary>
		BackgroundJob_ExpireOrders = 78,
		/// <summary>
		/// HL7BceInterface
		/// </summary>
		HL7BceInterface = 79,
        /// <summary>
        /// HL7AutoInstrumentInterface
        /// </summary>
        HL7AutoInstrumentInterface = 80,
        /// <summary>
        /// UC115BloodUnitTabView
        /// </summary>
        UC115BloodUnitTabView = 81,
        /// <summary>
        /// UC115BloodUnitTabView
        /// </summary>
        UC115SpecimenTabView = 82,       
        /// <summary>
		/// UnitTests = 9999
		/// </summary>
		UnitTests = 9999
	}

	/// <summary>
	/// Process that create workload events.
	/// </summary>
	public enum WorkloadProcessID
	{
		/// <summary>
		///     Unknown
		/// </summary>
		/// <remarks>
		///     
		/// </remarks>
		Unknown = 0,
		/// <summary>
		///     ABO Forward and reverse typing (patient) UC_21
		/// </summary>
		/// <remarks>
		///     
		/// </remarks>
		ABOForwardReverseTypingPatient = 1, 
		/// <summary>
		///     ABO Forward and reverse typing (patient) Repeat Test UC_52
		/// </summary>
		/// <remarks>
		///     
		/// </remarks>
	    ABOForwardReverseTypingPatientRepeatTest = 2,
		/// <summary>
		///     ABO Forward typing (unit) UC_02
		/// </summary>
		/// <remarks>
		///     
		/// </remarks>
		ABOForwardTypingUnit = 3, 	
		/// <summary>
		///     ABO/RH Forward typing (unit) UC_02
		/// </summary>
		/// <remarks>
		///     
		/// </remarks>
		ABORhForwardTypingUnit = 4,
		/// <summary>
		///     Accept Order UC_16
		/// </summary>
		/// <remarks>
		///     
		/// </remarks>
		AcceptOrder = 5,
		/// <summary>
		///     Antibody Identification UC_94
		/// </summary>
		/// <remarks>
		///     UC_94
		/// </remarks>
		AntibodyIdentificationWorkUp = 6, 
		/// <summary>
		///     Antibody screen (patient) UC_94
		/// </summary>
		/// <remarks>
		///    UC_94
		/// </remarks>
		AntibodyScreenPatient = 7,
		/// <summary>
		///     Antibody Screen (patient) Repeat Test UC_94
		/// </summary>
		/// <remarks>
		///    UC_94
		/// </remarks>
		/// 	
		AntibodyScreenPatientRepeatTest = 8,
		/// <summary>
		///     Antigen phenotyping, Multiple Test phases (QC) UC_41
		/// </summary>
		/// <remarks>
		///    UC_41
		/// </remarks>
		AntigenPhenotypingMultipleTestPhasesQC = 9,
		/// <summary>
		///    Antigen phenotyping, Single Test phase (QC) UC_41
		/// </summary>
		/// <remarks>
		///    UC_41
		/// </remarks>
		AntigenPhenotypingSingleTestPhaseQC = 10,
		/// <summary>
		///    Cancel Order UC_61
		/// </summary>
		/// <remarks>
		///    UC_61
		/// </remarks>
		CancelOrder = 11,
		/// <summary>
		///    Crossmatch unit, serologic immediate spin UC_40
		/// </summary>
		/// <remarks>
		///    UC_40
		/// </remarks>
		CrossmatchUnitSerologicImmediateSpin = 12,
		/// <summary>
		///    Crossmatch unit, serological Coombs UC_40
		/// </summary>
		/// <remarks>
		///    UC_40
		/// </remarks>
		CrossmatchUnitSerologicalCoombs = 13,
		/// <summary>
		///    Crossmatch, Repeat Test UC_40
		/// </summary>
		/// <remarks>
		///    UC_40
		/// </remarks>
		CrossmatchRepeatTest = 14,
		/// <summary>
		///    Daily Rack Quality Control (QC) UC_28
		/// </summary>
		/// <remarks>
		///    UC_28
		/// </remarks>
		DailyRackQualityControlQC = 15,
		/// <summary>
		///    DAT (QC)UC_54
		/// </summary>
		/// <remarks>
		///    UC_54
		/// </remarks>
		DATQC = 16,
		/// <summary>
		///    Deglycerolize unit UC_26
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks>
		DeglycerolizeUnit = 17,
		/// <summary>
		///    Direct Antiglobulin Test (DAT) UC_54
		/// </summary>
		/// <remarks>
		///    UC_54
		/// </remarks>
		DirectAntiglobulinTestDAT = 18,
		/// <summary>
		///    Direct Antiglobulin Test (DAT) Repeat test UC_54
		/// </summary>
		/// <remarks>
		///    UC_54
		/// </remarks>
		DirectAntiglobulinTestDATRepeatTest = 19,
		/// <summary>
		///    Discard unit UC_27
		/// </summary>
		/// <remarks>
		///    UC_27
		/// </remarks>
		DiscardUnit = 20,
		/// <summary>
		///    Electronic Crossmatch
		/// </summary>
		/// <remarks>
		///    UC_03
		/// </remarks>
		CrossmatchUnitElectronic = 21,
		/// <summary>
		///    Freeze unit UC_26
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks>	
		FreezeUnit = 22,
		/// <summary>
		///    Irradiate unit UC_26
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks>
		IrradiateUnit = 23,
		/// <summary>
		///    Issue unit UC_73
		/// </summary>
		/// <remarks>
		///    UC_73
		/// </remarks>
		IssueUnit = 24,
		/// <summary>
		///    Leukoreduce unit UC_26
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks>
		/// 
		LeukoreduceUnit = 25,
		/// <summary>
		///    Login Equipment UC_22
		/// </summary>
		/// <remarks>
		///    UC_22
		/// </remarks>
		LoginEquipment = 26,
		/// <summary>
		///    Login Reagent UC_20
		/// </summary>
		/// <remarks>
		///    UC_20
		/// </remarks> 	
		LoginReagent = 27,
		/// <summary>
		///    Login Supply UC_81
		/// </summary>
		/// <remarks>
		///    UC_81
		/// </remarks> 
		LoginSupply = 28,
		/// <summary>
		///    Maintain Specimen UC_35
		/// </summary>
		/// <remarks>
		///    UC_35
		/// </remarks> 	
		MaintainSpecimen = 29,
		/// <summary>
		///    Maintain Supply UC_81
		/// </summary>
		/// <remarks>
		///    UC_81
		/// </remarks> 
		MaintainSupply = 30,
		/// <summary>
		///    Patient antigen phenotype (multiple phases) UC_98
		/// </summary>
		/// <remarks>
		///    UC_98
		/// </remarks> 
		PatientAntigenPhenotypeMultiplePhases = 31,
		/// <summary>
		///    Patient antigen phenotype (single phase) UC_98
		/// </summary>
		/// <remarks>
		///    UC_98
		/// </remarks> 
		PatientAntigenPhenotypeSinglePhase = 32,
		/// <summary>
		///    Patient antigen phenotype (single phase) UC_98
		/// </summary>
		/// <remarks>
		///    UC_24
		/// </remarks> 
		PoolUnit = 33,
		/// <summary>
		///    	Quarantine unit UC_27
		/// </summary>
		/// <remarks>
		///    UC_27
		/// </remarks> 
		QuarantineUnit = 34,
		/// <summary>
		///    	Rejuvenate unit UC_26
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks> 
		RejuvenateUnit = 35,
		/// <summary>
		///    	Release directed unit UC_71
		/// </summary>
		/// <remarks>
		///    UC_71
		/// </remarks> 
	    ReleaseDirectedUnit = 36,
		/// <summary>
		///    Release unit from patient back to inventory UC_47
		/// </summary>
		/// <remarks>
		///    UC_47
		/// </remarks> 
		ReleaseUnitFromPatientBackToInventory = 37,
		/// <summary>
		///    Release unit from Quarantine UC_27
		/// </summary>
		/// <remarks>
		///    UC_27
		/// </remarks> 
		ReleaseUnitFromQuarantine = 38,
		/// <summary>
		///   Return Issued unit UC_59
		/// </summary>
		/// <remarks>
		///    UC_59
		/// </remarks> 
		ReturnIssuedUnit = 39,
		/// <summary>
		///  	Split unit UC_25
		/// </summary>
		/// <remarks>
		///    UC_25
		/// </remarks> 
		SplitUnit = 40,
		/// <summary>
		///  Merge
		/// </summary>
		/// <remarks>
		///    UC_68
		/// </remarks> 
		Merge = 41,
		/// <summary>
		///  Thaw
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks> 
		Thaw = 42,
		/// <summary>
		///  Thaw/pool Cryo
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks> 
		ThawPoolCryo = 43,
		/// <summary>
		///  Transfuse Unit
		/// </summary>
		/// <remarks>
		///    UC_69, 13
		/// </remarks> 
		TransfuseUnit = 44,
		/// <summary>
		///  Transfusion Reaction Investigation UC_78, 94
		/// </summary>
		/// <remarks>
		///    UC_78, 94
		/// </remarks> 
		TransfusionReactionInvestigation = 45,
		/// <summary>
		///  Unit Antigen phenotyping, Multiple Test phases UC_41
		/// </summary>
		/// <remarks>
		///    UC_41
		/// </remarks> 
		UnitAntigenPhenotypingMultipleTestPhases = 46,
		/// <summary>
		///  Unit Antigen phenotyping, Single Test phase UC_41
		/// </summary>
		/// <remarks>
		///    UC_41
		/// </remarks> 
		UnitAntigenPhenotypingSingleTestPhase = 47,
		/// <summary>
		///  Unit login UC_01
		/// </summary>
		/// <remarks>
		///    UC_01
		/// </remarks> 
		UnitLogin = 48,
		/// <summary>
		///  Unit login UC_11
		/// </summary>
		/// <remarks>
		///    UC_11
		/// </remarks> 
		UnitLogout = 49,
		/// <summary>
		///  Update Equipment Record UC_22
		/// </summary>
		/// <remarks>
		///    UC_22
		/// </remarks> 
		UpdateEquipmentRecord = 50,
		/// <summary>
		///  Update Reagent Inventory UC_20
		/// </summary>
		/// <remarks>
		///    UC_20
		/// </remarks> 
		UpdateReagentInventory = 51,
		/// <summary>
		///  Wash Unit
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks> 
		WashUnit = 52,
		/// <summary>
		///  Justification UC_100
		/// </summary>
		/// <remarks>
		///    UC_100
		/// </remarks> 
		Justification = 53,
		/// <summary>
		/// Update Supply Inventory
		/// </summary>
		/// <remarks>
		///    UC_81
		/// </remarks> 
		UpdateSupplyInventory = 54,
		/// <summary>
		/// Volume Reduce Unit
		/// </summary>
		/// <remarks>
		///    UC_26
		/// </remarks> 
		VolumeReduce = 55,
		/// <summary>
		/// Patient ABO Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedPatientABO = 56,
		/// <summary>
		/// Antibody Screen/Indirect Coombs Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedAntiBodyScreen = 57,
		/// <summary>
		/// Serologic Crossmatch, Major, Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedSerologicCrossmatch= 58,
		/// <summary>
		/// Direct Antiglobulin Test Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedDAT = 59,
		/// <summary>
		/// Patient Antigen Typing Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedPatientAntigenTyping = 60,
		/// <summary>
		/// Blood Unit ABO Confirmation Test Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedUnitAbo = 61,
		/// <summary>
		/// Blood Unit ABO/Rh Confirmation Test Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedUnitAboRh = 62,
		/// <summary>
        /// Blood Unit Antigen Typing Automated
		/// </summary>
		/// <remarks>
		///    UC_115
		/// </remarks> 
		AutomatedUnitAntigenTyping = 63,
	}
	/// <summary>
	///     Status of workload event
	/// </summary>
	/// <remarks>
	///     
	/// </remarks>
	public enum WorkloadEventStatus
	{
		/// <summary>
		///     Workload event status is unknown
		/// </summary>
		Unknown = '0',
		/// <summary>
		/// Error occured for workload event    
		/// </summary>
		Error = 'E',
		/// <summary>
		/// Workload event is InProcess      
		/// </summary>
		InProcess = 'I',
		/// <summary>
		/// Workload event is pending processing    
		/// </summary>
		PendingProcessing = 'P',
		/// <summary>
		///     Workload event is sucessfully processed
		/// </summary>
		SucessfullyProcessed = 'S'
	}
	/// <summary>
	/// BarcodeType
	/// </summary>
	public enum BarcodeType
	{
		/// <summary>
		/// Codabar = 'C'
		/// </summary>
		Codabar = 'C',
		/// <summary>
		/// ISBT128 ='I'
		/// </summary>
		ISBT128 ='I',
		/// <summary>
		/// None
		/// </summary>
		None
	};

	/// <summary>
	/// WorkloadTransactionType
	/// </summary>
	public enum WorkloadTransactionType
	{
		/// <summary>
		/// Unit = 'U'
		/// </summary>
		Unit = 'U',
		/// <summary>
		/// Miscellanious ='M'
		/// </summary>
		Miscellanious ='M',
		/// <summary>
		/// Patient = 'P'
		/// </summary>
		Patient = 'P',
		/// <summary>
		///	Order = 'O'    
		/// </summary>
		Order = 'O'
	};

	/// <summary>
	/// UserRoleType
	/// **** 508 Compliance ***
	/// </summary>
	public enum UserRoleType
	{
		/// <summary>
		/// Unknown = 0
		/// </summary>
		Unknown = 0,
		/// <summary>
		/// Technologist
		/// </summary>
		Technologist = 1,
		/// <summary>
		/// EnhancedTechnologist
		/// </summary>
		EnhancedTechnologist = 2,
		/// <summary>
		/// LeadTechnologist
		/// </summary>
		LeadTechnologist = 3,
		/// <summary>
		/// TraditionalSupervisor
		/// </summary>
		TraditionalSupervisor = 4,
		/// <summary>
		/// EnhancedSupervisor
		/// </summary>
		EnhancedSupervisor = 5,
		/// <summary>
		/// AdministratorSupervisor
		/// </summary>
		AdministratorSupervisor = 6,
		/// <summary>
		/// VisuallyImpairedTechnologist
		/// </summary>
		VisuallyImpairedTechnologist = 7,
		/// <summary>
		/// VisuallyImpairedEnhancedTechnologist
		/// </summary>
		VisuallyImpairedEnhancedTechnologist = 8,
		/// <summary>
		/// VisuallyImpairedLeadTechnologist
		/// </summary>
		VisuallyImpairedLeadTechnologist = 9,
		/// <summary>
		/// VisuallyImpairedTraditionalSupervisor
		/// </summary>
		VisuallyImpairedTraditionalSupervisor = 10,
		/// <summary>
		/// VisuallyImpairedEnhancedSupervisor
		/// </summary>
		VisuallyImpairedEnhancedSupervisor = 11,
		/// <summary>
		/// VisuallyImpairedAdministratorSupervisor
		/// </summary>
		VisuallyImpairedAdministratorSupervisor = 12
	};

	/// <summary>
	/// LocationType
	/// </summary>
	public enum LocationType
	{
		/// <summary>
		/// Inpatient = 'I'
		/// </summary>
		Inpatient = 'I',
		/// <summary>
		/// Outpatient = 'O'
		/// </summary>
		Outpatient = 'O',
		/// <summary>
		/// Other = 'X'
		/// </summary>
		Other = 'X',
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue
	};
	/// <summary>
	/// RH
	/// </summary>
	public enum RH
	{
		/// <summary>
		/// Negative = 0
		/// </summary>
		Negative = 0,
		/// <summary>
		/// NotProvided
		/// </summary>
		NotProvided,
		/// <summary>
		/// Positive
		/// </summary>
		Positive,
		/// <summary>
		/// Inconclusive
		/// </summary>
		Inconclusive,
		/// <summary>
		/// PooledRH
		/// </summary>
		PooledRH,
		/// <summary>
		/// No RH value.  It was coclusive or provided as "none"
		/// </summary>
		Blank

	};
	/// <summary>
	/// ABO
	/// </summary>
	public enum ABO
	{
		/// <summary>
		/// A = 0
		/// </summary>
		A = 0,
		/// <summary>
		/// AB
		/// </summary>
		AB,
		/// <summary>
		/// B
		/// </summary>
		B,
		/// <summary>
		/// I
		/// </summary>
		I,
		/// <summary>
		/// Mx - for Pooling, Needs to stay 2 chars because BloodTypeCode is 2 char on BloodUnitMedia
		/// </summary>
		Mx,
		/// <summary>
		/// NA
		/// </summary>
		NA,
		/// <summary>
		/// O
		/// </summary>
		O
		
	};
	/// <summary>
	/// RecordStatusCode
	/// </summary>
	public enum RecordStatusCode
	{
		/// <summary>
		/// Active = 'A'
		/// </summary>
		Active = 'A',
		/// <summary>
		/// Converted = 'C'
		/// </summary>
		Converted = 'C',
		/// <summary>
		/// ErrorCorrected = 'E'
		/// </summary>
		ErrorCorrected = 'E',
		/// <summary>
		/// Historical = 'H'
		/// </summary>
		Historical = 'H',
		/// <summary>
		/// Incomplete = 'I'
		/// </summary>
		Incomplete = 'I',
		/// <summary>
		/// LocalEntry = 'L'
		/// </summary>
		LocalEntry = 'L',
		/// <summary>
		/// NationalStandard = 'N'
		/// </summary>
		NationalStandard = 'N',
		/// <summary>
		/// Inactive = 'X'
		/// </summary>
		Inactive = 'X',
		/// <summary>
		/// Modified = 'M'
		/// </summary>
		Modified = 'M',
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue
	};
	/// <summary>
	/// UnitStatusCode
	/// </summary>
	public enum UnitStatusCode
	{
		/// <summary>
		/// Available = 'A'
		/// </summary>
		Available = 'A',
		/// <summary>
		/// CrossmatchedAssigned = 'C'
		/// </summary>
		CrossmatchedAssigned = 'C',
		/// <summary>
		/// Discarded = 'D'
		/// </summary>
		Discarded = 'D',
		/// <summary>
		/// Issued = 'I'
		/// </summary>
		Issued = 'I',
		/// <summary>
		/// Limited = 'L'
		/// </summary>
		Limited = 'L',
		/// <summary>
		/// Modified = 'M'
		/// </summary>
		Modified = 'M',
		/// <summary>
		/// Returned = 'R'
		/// </summary>
		Returned = 'R',
		/// <summary>
		/// Transfused = 'T'
		/// </summary>
		Transfused = 'T',
		/// <summary>
		/// Transferred = 'X'
		/// </summary>
		Transferred = 'X',
		/// <summary>
		/// Assigned = 'S'
		/// </summary>
		Assigned = 'S',
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue
	};
	/// <summary>
	/// DiscardDetail
	/// </summary>
	public enum DiscardDetail
	{
		/// <summary>
		/// DispositionForResearch = 'D'
		/// </summary>
		DispositionForResearch = 'D',
		/// <summary>
		/// Incinerated = 'I'
		/// </summary>
		Incinerated = 'I',
		/// <summary>
		/// Punctured = 'P'
		/// </summary>
		Punctured = 'P',
		/// <summary>
		/// RupturedDuringThaw = 'R'
		/// </summary>
		RupturedDuringThaw = 'R',
		/// <summary>
		/// Other = 'O'
		/// </summary>
		Other = 'O'
	};
	/// <summary>
	/// QuarantineDetail
	/// </summary>
	public enum QuarantineDetail
	{
		/// <summary>
		/// IncompleteDonorScreeningTest = 'I'
		/// </summary>
		IncompleteDonorScreeningTest = 'I',
		/// <summary>
		/// PositiveDonorScreeningTest = 'P'
		/// </summary>
		PositiveDonorScreeningTest = 'P',
		/// <summary>
		/// StorageOutsideMonitoredArea = 'S'
		/// </summary>
		StorageOutsideMonitoredArea = 'S',
		/// <summary>
		/// VisualInspectionUnsatisfactory = 'V'
		/// </summary>
		VisualInspectionUnsatisfactory = 'V',
		/// <summary>
		/// ABOInconclusive = 'A'
		/// </summary>
		ABOInconclusive = 'A',
		/// <summary>
		/// Other = 'O'
		/// </summary>
		Other = 'O'
	};

	/// <summary>
	/// FunctionCode - VBECS Security.
	/// </summary>
	public enum FunctionCode
	{
		/// <summary>
		/// PerformStandardVBECSFunctions = 0
		/// </summary>
		PerformStandardVBECSFunctions = 0,
		/// <summary>
		/// DefineDivisions = 1
		/// </summary>
		DefineDivisions = 1,
		/// <summary>
		/// DefineReciprocity = 2
		/// </summary>
		DefineReciprocity = 2,
		/// <summary>
		/// DefineVBECSUsers = 3
		/// </summary>
		DefineVBECSUsers = 3,
		/// <summary>
		/// DefineDivisionServiceLevel = 4
		/// </summary>
		DefineDivisionServiceLevel = 4,
		/// <summary>
		/// EnableElectronicXMatch = 5
		/// </summary>
		EnableElectronicXMatch = 5,
		/// <summary>
		/// PopulateICCBBANumber = 6
		/// </summary>
		PopulateICCBBANumber = 6,
		/// <summary>
		/// DefineValidUnitModifications = 7
		/// </summary>
		DefineValidUnitModifications = 7,
		/// <summary>
		/// EditAntigenFrequencyTable = 8
		/// </summary>
		EditAntigenFrequencyTable = 8,
		/// <summary>
		/// AssignWorkLoadCodes = 9
		/// </summary>
		AssignWorkLoadCodes = 9,
		/// <summary>
		/// AddNewLocalShipper = 10
		/// </summary>
		AddNewLocalShipper = 10,
		/// <summary>
		/// AddNewBloodProduct = 11
		/// </summary>
		AddNewBloodProduct = 11,
		/// <summary>
		/// EditAndCreateCannedComments = 12
		/// </summary>
		EditAndCreateCannedComments = 12,
		/// <summary>
		/// EditConsultativeReports = 13
		/// </summary>
		EditConsultativeReports = 13,
		/// <summary>
		/// SelectIssueABOIncompatibleblood = 15
		/// </summary>
		SelectIssueABOIncompatibleblood = 15,
		/// <summary>
		/// IssueAntigenPosOrUntypedRedbloodcells = 16
		/// </summary>
		IssueAntigenPosOrUntypedRedbloodcells = 16,
		/// <summary>
		/// EditPermanentRecordPatientHistoricABORh = 17
		/// </summary>
		EditPermanentRecordPatientHistoricABORh = 17,
		/// <summary>
		/// EditPermanentRecordPatientRedCellAntibody = 18
		/// </summary>
		EditPermanentRecordPatientRedCellAntibody = 18,
		/// <summary>
		/// EditBloodUnitLongitudinalRecord = 19
		/// </summary>
		EditBloodUnitLongitudinalRecord = 19,
		/// <summary>
		/// EditPatientRecordVerifiedDataTestResults = 20
		/// </summary>
		EditPatientRecordVerifiedDataTestResults = 20,
		/// <summary>
		/// IssueIncompatibleRedcellBloodunits = 22
		/// </summary>
		IssueIncompatibleRedcellBloodunits = 22,
		/// <summary>
		/// ReleaseDirectedUnits = 23
		/// </summary>
		ReleaseDirectedUnits = 23,
		/// <summary>
		/// EditVerifiedUnitConfirmationTesting = 24
		/// </summary>
		EditVerifiedUnitConfirmationTesting = 24,
		/// <summary>
		/// EditUnitLoginPriortoPatientAssociation = 25
		/// </summary>
		EditUnitLoginPriortoPatientAssociation = 25,
		/// <summary>
		/// ReleaseBloodproductsFromQuarantine = 26
		/// </summary>
		ReleaseBloodproductsFromQuarantine = 26,
		/// <summary>
		/// ActivateEditShipperInformation = 28
		/// </summary>
		ActivateEditShipperInformation = 28,
		/// <summary>
		/// ActivateEditBloodProductInformation = 29
		/// </summary>
		ActivateEditBloodProductInformation = 29,
		/// <summary>
		/// IssueExpiredBloodProducts = 30
		/// </summary>
		IssueExpiredBloodProducts = 30,
		/// <summary>
		/// StandardAccess = 31
		/// </summary>
		StandardAccess = 31,
		/// <summary>
		/// ConfigureTesting = 32
		/// </summary>
		ConfigureTesting = 32,
		/// <summary>
		/// InactivateTransfusionRequirement = 34
		/// </summary>
		InactivateTransfusionRequirement = 34,
		/// <summary>
		/// MaintainMinimumLevels = 14
		/// </summary>
		MaintainMinimumLevels = 14,
		/// <summary>
		/// EditUnitCost = 33
		/// </summary>
		EditUnitCost = 33,
		/// <summary>
		/// PrintInternalReports = 35
		/// </summary>
		PrintInternalReports = 35,
		/// <summary>
		/// ConfigureDivision = 38
		/// </summary>
		ConfigureDivision = 38,
		/// <summary>
		/// MaintainLoginMessage = 39
		/// </summary>
		MaintainLoginMessage = 39,
		/// <summary>
		/// CR 2553, 2554
		/// EditPatientTransfusionRecord = 40 
		/// </summary>
		EditPatientTransfusionRecord = 40,
		/// <summary>
		/// CR 2553, 2554
		/// RemoveFinalStatus = 41
		/// </summary>
		RemoveFinalStatus = 41,
		/// <summary>
		/// AutomatedInstrumentTest = 42
		/// </summary>
		AutomatedInstrumentTest = 42
	};
	/// <summary>
	/// ComponentClass
	/// </summary>
	public enum ComponentClass
	{
		/// <summary>
		/// RBC = 1
		/// </summary>
		RBC = 1,
		/// <summary>
		/// FFP = 2
		/// </summary>
		FFP = 2,
		/// <summary>
		/// CRYO = 3
		/// </summary>
		CRYO = 3,
		/// <summary>
		/// PLT = 4
		/// </summary>
		PLT = 4,
		/// <summary>
		/// Other = 5
		/// </summary>
		Other = 5,
		/// <summary>
		/// WB = 6
		/// </summary>
		WB = 6,
		/// <summary>
		/// ConversionClass = 9
		/// </summary>
		ConversionClass = 9
	};
	/// <summary>
	/// ComponentRequirement
	/// </summary>
	public enum ComponentRequirement
	{
		/// <summary>
		/// IRRADIATE = 1
		/// </summary>
		IRRADIATE = 1,
		/// <summary>
		/// LEUKORED = 2
		/// </summary>
		LEUKORED = 2,
		/// <summary>
		/// WASHEDRBC = 3
		/// </summary>
		WASHEDRBC = 3,
		/// <summary>
		/// WASHEDPLT = 4
		/// </summary>
		WASHEDPLT = 4,
		/// <summary>
		/// SCNEG = 5
		/// </summary>
		SCNEG = 5,
		/// <summary>
		/// CMVNEG = 6
		/// </summary>
		CMVNEG = 6
	};

    ///<Defect>251417</Defect>
    /// <summary>
    /// Type of conflict - used to support Automated Instrument "Virtual locking" 
    /// </summary>
    public enum LockConflictType
    {
        /// <summary>
        /// An error happened while creating the lock - e.g. LockRecord() encounters an exception
        /// </summary>
        ErrorCreatingLock = -1,
        /// <summary>
        /// There is no conflict
        /// </summary>
        NoConflict = 0,
        /// <summary>
        /// There was a lock conflict - record exists on VbecsLock table
        /// </summary>
        PhysicalLock = 1,
        /// <summary>
        /// "Virtual" lock - PendingBloodUnitTest exists with BloodUnitGuid
        /// </summary>
        PendingBloodUnitTestExists_SingleUnit = 2,
        /// <summary>
        /// "Virtual" lock - PendingBloodUnitTest exists with only UnitId (specific unit not known)
        /// </summary>
        PendingBloodUnitTestExists_UnknownUnit = 3,
        /// <summary>
        /// "Virutal" lock - PendingSpecimenTest exists, on OrderedUnitGuid (single unit match)
        /// </summary>
        PendingSpecimentTestExists_OnOrderedUnit_UnitMatch = 4,
        /// <summary>
        /// "Virutal" lock - PendingSpecimenTest exists, on OrderedUnitGuid (no single unit match)
        /// </summary>
        PendingSpecimentTestExists_OnOrderedUnit_NoUnitMatch = 5,
        /// <summary>
        /// "Virutal" lock - PendingSpecimenTest exists, on PatientSpecimenGuid
        /// </summary>
        PendingSpecimentTestExists_OnPatientSpecimen = 6,
        /// <summary>
        /// "Virutal" lock - PendingSpecimenTest exists, on OrderedTestGuid
        /// </summary>
        PendingSpecimentTestExists_OnOrderedTest = 7
    }


    /// <summary>
	/// LockFunctions - VBECS Locks- Must Match the VBECSLockFunction table
	/// </summary>
	public enum LockFunctions
	{
		/// <summary>
		/// Unknown = -1
		/// </summary>
		NA = -1,
		/// <summary>
		/// UC001ProcessIncomingShipment = 1
		/// </summary>
		UC001ProcessIncomingShipment = 1,
		/// <summary>
		/// UC002AboRHConfirmation = 2
		/// </summary>
		UC002AboRHConfirmation = 2,
		/// <summary>
		/// UC003SelectUnitsForPatient = 3
		/// </summary>
		UC003SelectUnitsForPatient = 3,
		/// <summary>
		/// UC004BuildCustomWorklist = 4
		/// </summary>
		UC004BuildCustomWorklist = 4,
		/// <summary>
		/// UC005SelectUnit = 5
		/// </summary>
		UC005SelectUnit = 5,
		/// <summary>
		/// UC006MaintainCollectionFacility = 6
		/// </summary>
		UC006MaintainCollectionFacility = 6,
		/// <summary>
		/// UC008MaintainBloodProduct = 8
		/// </summary>
		UC008MaintainBloodProduct = 8,
		/// <summary>
		/// UC009MaintainVamcDivision = 9
		/// </summary>
		UC009MaintainVamcDivision = 9,
		/// <summary>
		/// UC011_utgoingShipment = 11
		/// </summary>
		UC011OutgoingShipment = 11,
		/// <summary>
		/// UC013RemoveFinalUnitStatus = 13
		/// </summary>
		UC013RemoveFinalUnitStatus = 13,
		/// <summary>
		/// UC014EditUnitFinancialData = 14
		/// </summary>
		UC014EditUnitFinancialData = 14,
		/// <summary>
		/// UC016AcceptOrder = 16
		/// </summary>
		UC016AcceptOrder = 16,
		/// <summary>
		/// UC017CreateShipppingInvoiceTemplate = 17
		/// </summary>
		UC017CreateShipppingInvoiceTemplate = 17,
		/// <summary>
		/// UC018VbecsDivisionLogon = 18
		/// </summary>
		UC018VbecsDivisionLogon = 18,
		/// <summary>
		/// UC019MaintainVbecsUser = 19
		/// </summary>
		UC019MaintainVbecsUser = 19,
		/// <summary>
		/// UC020MaintainReagentInventory = 20
		/// </summary>
		UC020MaintainReagentInventory = 20,
		/// <summary>
		/// UC021RecordTransfusionReactionWorkup = 21
		/// </summary>
		UC021RecordTransfusionReactionWorkup = 21,
		/// <summary>
		/// UC022MaintainBloodBankEquipment = 22
		/// </summary>
		UC022MaintainBloodBankEquipment = 22,
		/// <summary>
		/// UC023MaintainAntibodyTable = 23
		/// </summary>
		UC023MaintainAntibodyTable = 23,
		/// <summary>
		/// UC024PoolUnits = 24
		/// </summary>
		UC024PoolUnits = 24,
		/// <summary>
		/// UC025SplitUnits = 25
		/// </summary>
		UC025SplitUnits = 25,
		/// <summary>
		/// UC026ModifyUnits = 26
		/// </summary>
		UC026ModifyUnits = 26,
		/// <summary>
		/// UC027DiscardQuarantine = 27
		/// </summary>
		UC027DiscardQuarantine = 27,
		/// <summary>
		/// UC028EnterReagentQCResults = 28
		/// </summary>
		UC028EnterReagentQCResults = 28,
		/// <summary>
		/// UC029AssignWorkloadCodes = 29
		/// </summary>
		UC029AssignWorkloadCodes = 29,
		/// <summary>
		/// UC031MaintainCannedComments = 31
		/// </summary>
		UC031MaintainCannedComments = 31,
		/// <summary>
		/// UC032MaintainMsbos = 32
		/// </summary>
		UC032MaintainMsbos = 32,
		/// <summary>
		/// UC033DefineTransfusionEffectivenessReportTesting = 33
		/// </summary>
		UC033DefineTransfusionEffectivenessReportTesting = 33,
		/// <summary>
		/// UC034MaintainTransfusionComplications = 34
		/// </summary>
		UC034MaintainTransfusionComplications = 34,
		/// <summary>
		/// UC035MaintainSpecimen = 35
		/// </summary>
		UC035MaintainSpecimen = 35,
		/// <summary>
		/// UC038DefinePatientTransfusionRequirements = 38
		/// </summary>
		UC038DefinePatientTransfusionRequirements = 38,
		/// <summary>
		/// UC041RecordPhenotypeResults = 41
		/// </summary>
		UC041RecordPhenotypeResults = 41,
		/// <summary>
		/// UC042GenerateFullFaceLabel = 42
		/// </summary>
		UC042GenerateFullFaceLabel = 42,
		/// <summary>
		/// UC043PrintUnitCautionTag = 43
		/// </summary>
		UC043PrintUnitCautionTag = 43,
		/// <summary>
		/// UC045OrderReflexTests = 45
		/// </summary>
		UC045OrderReflexTests = 45,
		/// <summary>
		/// UC047ReleaseUnitFromPatientAssignment = 47
		/// </summary>
		UC047ReleaseUnitFromPatientAssignment = 47,
		/// <summary>
		/// UC048ReportTestingWorklist = 48
		/// </summary>
		UC048ReportTestingWorklist = 48,
		/// <summary>
		/// UC049ReportBloodAvailability = 49
		/// </summary>
		UC049ReportBloodAvailability = 49,
		/// <summary>
		/// UC050ConfigureComponentClasses = 50
		/// </summary>
		UC050ConfigureComponentClasses = 50,
		/// <summary>
		/// UC051ConfigureDailyReagentQC = 51
		/// </summary>
		UC051ConfigureDailyReagentQC = 51,
		/// <summary>
		/// UC056RecordTesting = 56
		/// </summary>
		UC056RecordTesting = 56,
		/// <summary>
		/// UC058MaintainReagentMinInventoryLevels = 58
		/// </summary>
		UC058MaintainReagentMinInventoryLevels = 58,
		/// <summary>
		/// UC059ReturnIssuedUnits = 59
		/// </summary>
		UC059ReturnIssuedUnits = 59,
		/// <summary>
		/// UC060PopulatePatientChart = 60
		/// </summary>
		UC060PopulatePatientChart = 60,
		/// <summary>
		/// UC061CancelPendingOrder = 61
		/// </summary>
		UC061CancelPendingOrder = 61,
		/// <summary>
		/// UC064PatientConsultationReport = 64
		/// </summary>
		UC064PatientConsultationReport = 64,
		/// <summary>
		/// MUC03_EditVbecsUserParameters = 67
		/// </summary>
		MUC03_EditVbecsUserParameters = 67,
		/// <summary>
		/// UC068DuplicatePatientMerge = 68
		/// </summary>
		UC068DuplicatePatientMerge = 68,
		/// <summary>
		/// UC069PostTransfusionInformation = 69
		/// </summary>
		UC069PostTransfusionInformation = 69,
		/// <summary>
		/// UC070EditUnitProcessing = 70
		/// </summary>
		UC070EditUnitProcessing = 70,
		/// <summary>
		/// UC071FreeDirectedUnitForCrossover = 71
		/// </summary>
		UC071FreeDirectedUnitForCrossover = 71,
		/// <summary>
		/// UC072CancelActiveOrder = 72
		/// </summary>
		UC072CancelActiveOrder = 72,
		/// <summary>
		/// UC073IssueBloodComponents = 73
		/// </summary>
		UC073IssueBloodComponents = 73,
		/// <summary>
		/// UC077AuditTrailReport = 77
		/// </summary>
		UC077AuditTrailReport = 77,
		/// <summary>
		/// UC078GenerateTrwReports = 78
		/// </summary>
		UC078GenerateTrwReports = 78,
		/// <summary>
		/// UC081MaintainBloodBankSupplies = 81
		/// </summary>
		UC081MaintainBloodBankSupplies = 81,
		/// <summary>
		/// UC082ExceptionReport = 82
		/// </summary>
		UC082ExceptionReport = 82,
		/// <summary>
		/// UC092PendingTaskList = 92
		/// </summary>
		UC092PendingTaskList = 92,
		/// <summary>
		/// UC094InvalidatePatientTestResults = 94
		/// </summary>
		UC094InvalidatePatientTestResults = 94,
		/// <summary>
		/// UC100JustifyPatientABORh = 100
		/// </summary>
		UC100JustifyPatientABORh = 100,
        /// <summary>
        /// UC114AutomatedTestingParser = 114
        /// </summary>
        UC114AutomatedTestingParser = 114,
        /// <summary>
        /// UC115AutomatedTestingReview = 115
        /// </summary>
        UC115AutomatedTestingReview = 115,
		/// <summary>
		/// UnitTests = 999
		/// </summary>
		UnitTests = 999,
		/// <summary>
		/// DssExtract = 997
		/// </summary>
		DssExtract = 997,
        /// <summary>
        /// BatchJobExpireComponentOrders = 996
        /// </summary>
        BatchJobExpireComponentOrders = 996,
		/// <summary>
        /// BatchJobExpireTestOrders = 995
		/// </summary>
        BatchJobExpireTestOrders = 995,
        /// <summary>
        /// BatchJobMarkUnitsPresumedTransfused = 994
        /// </summary>
        BatchJobMarkUnitsPresumedTransfused = 994

	}

	/// <summary>
	/// String resource types
	/// </summary>
	public enum StringResourceType : int
	{
		/// <summary>
		/// SystemError = 0
		/// </summary>
		SystemError = 0,
		/// <summary>
		/// Validation = 1
		/// </summary>
		Validation = 1,
		/// <summary>
		/// Information = 2
		/// </summary>
		Information = 2,
		/// <summary>
		/// Confirmation = 3
		/// </summary>
		Confirmation = 3,
		/// <summary>
		/// Prompt = 4
		/// </summary>
		Prompt = 4,
		/// <summary>
		/// Other = 5
		/// </summary>
		Other = 5,
		/// <summary>
		/// Tooltip = 6
		/// </summary>
		Tooltip = 6,
		/// <summary>
		/// ResourceRetrievalFailure = 7
		/// </summary>
		ResourceRetrievalFailure = 7,
		/// <summary>
		/// MessageTitle = 8
		/// </summary>
		MessageTitle = 8,
		/// <summary>
		/// HelpFileMappings = 9
		/// </summary>
		HelpFileMappings = 9
}

	/// <summary>
	/// Matches the SupplyType system table
	/// </summary>
	public enum SupplyType : int
	{
		/// <summary>
		/// AllSupplies = int.MinValue
		/// </summary>
		AllSupplies = int.MinValue,
		/// <summary>
		/// Unknown = 0
		/// </summary>
		Unknown = 0,
		/// <summary>
		/// Saline = 1
		/// </summary>
		Saline = 1,
		/// <summary>
		/// BloodFilters = 2
		/// </summary>
		BloodFilters = 2,
		/// <summary>
		/// Containers =3
		/// </summary>
		Containers =3,
		/// <summary>
		/// DeglycerolizingSolutions = 4
		/// </summary>
		DeglycerolizingSolutions = 4,
		/// <summary>
		/// FreezingSolutions = 5
		/// </summary>
		FreezingSolutions = 5,
		/// <summary>
		/// Pipettes = 6
		/// </summary>
		Pipettes = 6,
		/// <summary>
		/// TestTubes = 7
		/// </summary>
		TestTubes = 7,
		/// <summary>
		/// Gloves = 8
		/// </summary>
		Gloves = 8,
		/// <summary>
		/// PrinterPaper = 9
		/// </summary>
		PrinterPaper = 9,
		/// <summary>
		/// SCDWafer = 10
		/// </summary>
		SCDWafer = 10,
		/// <summary>
		/// OverlayLabels = 11
		/// </summary>
		OverlayLabels = 11,
		/// <summary>
		/// LabelStock = 12
		/// </summary>
		LabelStock = 12,
		/// <summary>
		/// OtherEach = 13
		/// </summary>
		OtherEach = 13,
		/// <summary>
		/// OtherBox = 14
		/// </summary>
		OtherBox = 14
	}


	/// <summary>
	/// ReportType
	/// </summary>
	public enum ReportType
	{
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown,
		/// <summary>
		/// AuditTrail
		/// </summary>
		AuditTrail,
		/// <summary>
		/// CostAccounting
		/// </summary>
		CostAccounting,
		/// <summary>
		/// DivisionInventory
		/// </summary>
		DivisionInventory,
		/// <summary>
		/// DownTime
		/// </summary>
		DownTime,
		/// <summary>
		/// DivisionWorkload
		/// </summary>
		DivisionWorkload,
		/// <summary>
		/// Exception
		/// </summary>
		Exception,
		/// <summary>
		/// TransfusionComplication
		/// </summary>
		TransfusionComplication,
		/// <summary>
		/// TransfusionEffectiveness
		/// </summary>
		TransfusionEffectiveness,
		/// <summary>
		/// InappropriateTransfusionRequest
		/// </summary>
		InappropriateTransfusionRequest
	}
	/// <summary>
	/// ShipmentDirection
	/// </summary>
	public enum ShipmentDirection
	{
		/// <summary>
		/// OutgoingShipment
		/// </summary>
		OutgoingShipment,
		/// <summary>
		/// IncomingShipment
		/// </summary>
		IncomingShipment,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	}
	/// <summary>
	/// SpecimenType
	/// </summary>
	public enum SpecimenType
	{
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue,
		/// <summary>
		/// Blood = 'B'
		/// </summary>
		Blood = 'B',
		/// <summary>
		/// Plasma = 'P'
		/// </summary>
		Plasma = 'P',
		/// <summary>
		/// Serum = 'S'
		/// </summary>
		Serum = 'S'
	};
	/// <summary>
	/// TestEntryMethod
	/// </summary>
	public enum TestEntryMethod
	{
		/// <summary>
		/// Manual = 'M'
		/// </summary>
		Manual = 'M'
	}
	/// <summary>
	/// Commonly used Test Types
	/// </summary>
	public enum TestType
    {
        /// <summary>
        /// Unknown = 0
        /// </summary>
        Unknown = 0,
		/// <summary>
		/// AntiA = 15
		/// </summary>
		AntiA = 15,
		/// <summary>
		/// AntiB = 16
		/// </summary>
		AntiB = 16,
		/// <summary>
		/// AntiAB = 17
		/// </summary>
		AntiAB = 17,
		/// <summary>
		/// ABOInterp = 18
		/// </summary>
		ABOInterp = 18,
		/// <summary>
		/// AntiD = 19
		/// </summary>
		AntiD = 19,
		/// <summary>
		/// ControlD = 20
		/// </summary>
		ControlD = 20,
		/// <summary>
		/// RhInterp = 21
		/// </summary>
		RhInterp = 21,
		/// <summary>
		/// PlasmaA1Cells = 22
		/// </summary>
		PlasmaA1Cells = 22,
		/// <summary>
		/// PlasmaBCells = 24
		/// </summary>
		PlasmaBCells = 24,
		/// <summary>
        /// Anti_Dc_AHG = 29
		/// </summary>
        Anti_Dc_AHG = 29,
        /// <summary>
        /// ABS_IS_SC1 = 34
        /// </summary>
        ABS_AHG_SC1 = 34,
        /// <summary>
        /// ABS_AHG_SC2 = 38
        /// </summary>
        ABS_AHG_SC2 = 38,
        /// <summary>
        /// ABS_AHG_SC3 = 42
        /// </summary>
        ABS_AHG_SC3 = 42,
        /// <summary>
        /// ABS_AHG_SC4 = 46
        /// </summary>
        ABS_AHG_SC4 = 46,
        /// <summary>
        /// ABS_AUTO_SC5 = 50
        /// </summary>
        ABS_Auto_SC5 = 50,
        /// <summary>
        /// AntibodyScreen = 52
        /// </summary>
        AntibodyScreen = 52,
        /// <summary>
        /// DAT_Poly_AHG = 53
        /// </summary>
        DAT_Poly_AHG = 53,
        /// <summary>
        /// DAT_Poly_CC = 54
        /// </summary>
        DAT_Poly_CC = 54,
        /// <summary>
        /// DAT_lgG_AHG = 56
        /// </summary>
        DAT_lgG_AHG = 56,
        /// <summary>
        /// DAT_lgG_CC = 57
        /// </summary>
        DAT_lgG_CC = 57,
        /// <summary>
        /// DAT_Comp_AHG = 59
        /// </summary>
        DAT_Comp_AHG = 59,
        /// <summary>
        /// DAT_Comp_CC = 60
        /// </summary>
        DAT_Comp_CC = 60,
		/// <summary>
        /// AntiA_TAS = 62
		/// </summary>
		AntiA_TAS = 62,
		/// <summary>
        /// AntiB_TAS = 63
		/// </summary>
		AntiB_TAS = 63,
		/// <summary>
        /// AntiAB_TAS = 64
		/// </summary>
        AntiAB_TAS = 64,
        /// <summary>
        /// ABOInterpTAS = 65
        /// </summary>
        ABOInterpTAS = 65,
		/// <summary>
        /// AntiD_TAS = 66
		/// </summary>
		AntiD_TAS = 66,
		/// <summary>
		/// DControl = 67
		/// </summary>
        DControl = 67,
        /// <summary>
        /// RhInterpTAS = 68
        /// </summary>
        RhInterpTAS = 68,
		/// <summary>
		/// A1Cells = 69
		/// </summary>
		A1Cells = 69,
		/// <summary>
		/// BCells = 71
		/// </summary>
        BCells = 71,
        /// <summary>
        /// ABS_TAS_SC1 = 74
        /// </summary>
        ABS_TAS_SC1 = 74,
        /// <summary>
        /// ABS_TAS_SC2 = 78
        /// </summary>
        ABS_TAS_SC2 = 78,
        /// <summary>
        /// ABS_TAS_SC3 = 82
        /// </summary>
        ABS_TAS_SC3 = 82,
        /// <summary>
        /// ABS_TAS_SC4 = 86
        /// </summary>
        ABS_TAS_SC4 = 86,
        /// <summary>
        /// ABS_TAS_SC5 = 90
        /// </summary>
        ABS_TAS_SC5 = 90,
        /// <summary>
        /// AntibodyScreenTAS = 92
        /// </summary>
        AntibodyScreenTAS = 92,
        /// <summary>
        /// XM_IS = 98
        /// </summary>
        XM_IS = 98,
        /// <summary>
        /// XM_AHG = 100
        /// </summary>
        XM_AHG = 100,
        /// <summary>
        /// XM_AHG = 102
        /// </summary>
        XM_Interp = 102,
		/// <summary>
		/// SickleCell = 104
		/// </summary>
		SickleCell = 104,
		/// <summary>
		/// CMV = 103
		/// </summary>
        CMV = 103,
        /// <summary>
        /// AboRepeatAntiA = 115
        /// </summary>
        AboRepeatAntiA = 115,
        /// <summary>
        /// AboRepeatAntiB = 116
        /// </summary>
        AboRepeatAntiB = 116,
        /// <summary>
        /// AboRepeatAntiAB = 117
        /// </summary>
        AboRepeatAntiAB = 117,
		/// <summary>
		/// ABORepeat = 118
		/// </summary>
        ABORepeat = 118,
        /// <summary>
        /// AboRepeatAntiD = 119
        /// </summary>
        AboRepeatAntiD = 119,
        /// <summary>
        /// AboRepeatDControl = 120
        /// </summary>
        AboRepeatDControl = 120,
		/// <summary>
		/// RhRepeat = 121
		/// </summary>
        RhRepeat = 121,
        /// <summary>
        /// AboRepeatPlasmaA1Cells = 122
        /// </summary>
        AboRepeatPlasmaA1Cells = 122,
        /// <summary>
        /// AboRepeatPlasmaA2Cells = 123
        /// </summary>
        AboRepeatPlasmaA2Cells = 123,
        /// <summary>
        /// AboRepeatPlasmaBCells = 124
        /// </summary>
        AboRepeatPlasmaBCells = 124,
        /// <summary>
        /// AboRepeatReverseInterp = 125
        /// </summary>
        AboRepeatReverseInterp = 125,
        /// <summary>
        /// AbsRepeat_AHG_SC1 = 134
        /// </summary>
        AbsRepeat_AHG_SC1 = 134,
        /// <summary>
        /// AbsRepeat_AHG_SC2 = 138
        /// </summary>
        AbsRepeat_AHG_SC2 = 138,
        /// <summary>
        /// AbsRepeat_AHG_SC3 = 142
        /// </summary>
        AbsRepeat_AHG_SC3 = 142,
        /// <summary>
        /// AbsRepeat_AHG_SC4 = 146
        /// </summary>
        AbsRepeat_AHG_SC4 = 146,
        /// <summary>
        /// AbsRepeat_Auto_SC5 = 150
        /// </summary>
        AbsRepeat_Auto_SC5 = 150,
        /// <summary>
        /// AntibodyScreenRepeat = 152
        /// </summary>
        AntibodyScreenRepeat = 152,
        /// <summary>
        /// DATRepeat_Poly_AHG = 153
        /// </summary>
        DATRepeat_Poly_AHG = 153,
        /// <summary>
        /// DATRepeat_Poly_CC = 154
        /// </summary>
        DATRepeat_Poly_CC = 154,
        /// <summary>
        /// DATRepeat_lgG_AHG = 156
        /// </summary>
        DATRepeat_lgG_AHG = 156,
        /// <summary>
        /// DATRepeat_lgG_CC = 157
        /// </summary>
        DATRepeat_lgG_CC = 157,
        /// <summary>
        /// DATRepeat_Comp_AHG = 159
        /// </summary>
        DATRepeat_Comp_AHG = 159,
        /// <summary>
        /// DATRepeat_Comp_CC = 160
        /// </summary>
        DATRepeat_Comp_CC = 160,
        /// <summary>
        /// XMRepeatIS = 164
        /// </summary>
        XMRepeat_IS = 164,
        /// <summary>
        /// XMRepeat_AHG = 166
        /// </summary>
        XMRepeat_AHG = 166,
        /// <summary>
        /// XMRepeat_AHG = 168
        /// </summary>
        XMRepeat_Interp = 168,
		/// <summary>
        /// Anti_wD_AHG = 204
		/// </summary>
		Anti_wD_AHG = 204,
		/// <summary>
        /// wD_Interp = 206
		/// </summary>
        wD_Interp = 206,
		/// <summary>
        /// IS_Interp = 2139 - Used for pending automated test XM
		/// </summary>
        IS_Interp = 2139,
		/// <summary>
        /// IS_Interp = 2140 - Used for pending automated test XM
		/// </summary>
        AHG_Interp = 2140
	};
	/// <summary>
	/// ShipmentType - For Outgoing Shipment
	/// </summary>
	public enum ShipmentType
	{
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue,
		/// <summary>
		/// ReturnToSupplier = '1'
		/// </summary>
		ReturnToSupplier = '1',
		/// <summary>
		/// SendToOtherVA = '2'
		/// </summary>
		SendToOtherVA = '2',
		/// <summary>
		/// SendToOtherFacility ='3'
		/// </summary>
		SendToOtherFacility ='3'
	};
	/// <summary>
	/// TestingStatus - For Incoming Shipment
	/// </summary>
	public enum TestingStatus
	{
		/// <summary>
		/// Unknown = 0
		/// </summary>
		Unknown = 0,
		/// <summary>
		/// Negative
		/// </summary>
		Negative,
		/// <summary>
		/// Positive
		/// </summary>
		Positive,
		/// <summary>
		/// NotFullyTested
		/// </summary>
		NotFullyTested
	};
	/// <summary>
	/// Action for Discard or Quarantine UC27
	/// </summary>
	public enum Action
	{
		/// <summary>
		/// Discard = 0
		/// </summary>
		Discard = 0,
		/// <summary>
		/// Quarantine = 1
		/// </summary>
		Quarantine = 1,
		/// <summary>
		/// RemoveFromQuarantine = 2
		/// </summary>
		RemoveFromQuarantine = 2
	}
	/// <summary>
	/// DiscardComment for Discard or Quarantine UC27
	/// </summary>
	public enum DiscardComment
	{
		/// <summary>
		/// DispositionForResearch = 'D'
		/// </summary>
		DispositionForResearch = 'D',
		/// <summary>
		/// Incinerated = 'I'
		/// </summary>
		Incinerated = 'I',
		/// <summary>
		/// Punctured = 'P'
		/// </summary>
		Punctured = 'P',
		/// <summary>
		/// RupturedDuringThaw = 'R'
		/// </summary>
		RupturedDuringThaw = 'R',
		/// <summary>
		/// Other = 'O'
		/// </summary>
		Other = 'O',
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue
	};
	/// <summary>
	/// QuarantineComment for Discard or Quarantine UC27
	/// </summary>
	public enum QuarantineComment
	{
		/// <summary>
		/// IncompleteDonorScreeningTest = 'I'
		/// </summary>
		IncompleteDonorScreeningTest = 'I',
		/// <summary>
		/// PositiveDonorScreeningTest = 'P'
		/// </summary>
		PositiveDonorScreeningTest = 'P',
		/// <summary>
		/// StorageOutsideMonitoredArea = 'S'
		/// </summary>
		StorageOutsideMonitoredArea = 'S',
		/// <summary>
		/// VisualInspectionUnsatisfactory = 'V'
		/// </summary>
		VisualInspectionUnsatisfactory = 'V',
		/// <summary>
		/// ABOInconclusive = 'A'
		/// </summary>
		ABOInconclusive = 'A',
		/// <summary>
		/// Other = 'O'
		/// </summary>
		Other = 'O',
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue
	};
	/// <summary>
	/// DiscardDisposition
	/// </summary>
	public enum DiscardDisposition
	{
		/// <summary>
		/// Waste = 1
		/// </summary>
		Waste = 1,
		/// <summary>
		/// Credit = 2
		/// </summary>
		Credit = 2
	};
	/// <summary>
	/// ProductModification
	/// </summary>
	public enum ProductModification
	{
		/// <summary>
		/// Thawed = 'T'
		/// </summary>
		Thawed = 'T',
		/// <summary>
		/// Pooled = 'P'
		/// </summary>
		Pooled = 'P',
		/// <summary>
		/// PoolThawCryo = 'U'
		/// </summary>
		PoolThawCryo = 'U',
		/// <summary>
		/// SplitAdult = 'S'
		/// </summary>
		SplitAdult = 'S',
		/// <summary>
		/// Irradiated = 'I'
		/// </summary>
		Irradiated = 'I',
		/// <summary>
		/// LeukoReduced = 'L'
		/// </summary>
		LeukoReduced = 'L',
		/// <summary>
		/// VolumeReduced = 'V'
		/// </summary>
		VolumeReduced = 'V',
		/// <summary>
		/// Washed = 'W'
		/// </summary>
		Washed = 'W',
		/// <summary>
		/// Rejuvenated = 'R'
		/// </summary>
		Rejuvenated = 'R',
		/// <summary>
		/// Frozen = 'F'
		/// </summary>
		Frozen = 'F',
		/// <summary>
		/// Deglycerolized = 'D'
		/// </summary>
		Deglycerolized = 'D',
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue,
		/// <summary>
		/// EditPool = 'E'
		/// </summary>
		EditPool = 'E'
	};
	/// <summary>
	/// ModifyUnitMethod
	/// </summary>
	public enum ModifyUnitMethod
	{
		/// <summary>
		/// Open
		/// </summary>
		Open,
		/// <summary>
		/// SterileConnectingDevice
		/// </summary>
		SterileConnectingDevice,
		/// <summary>
		/// Closed
		/// </summary>
		Closed,
		/// <summary>
		/// None
		/// </summary>
		None
	};
	/// <summary>
	/// DonationType
	/// </summary>
	public enum DonationType
	{
		/// <summary>
		/// NotSpecified='0'
		/// </summary>
		NotSpecified='0',
		/// <summary>
		/// VolunteerAllogeneicDonor = 'V'
		/// </summary>
		VolunteerAllogeneicDonor = 'V',
		/// <summary>
		/// VolunteerResearchDonor = 'R'
		/// </summary>
		VolunteerResearchDonor = 'R',
		/// <summary>
		/// VolunteerSourceDonor = 'S'
		/// </summary>
		VolunteerSourceDonor = 'S',
		/// <summary>
		/// VolunteerTherapeuticCollection = 'T'
		/// </summary>
		VolunteerTherapeuticCollection = 'T',
		/// <summary>
		/// PaidAllogeneicCollection = 'P'
		/// </summary>
		PaidAllogeneicCollection = 'P',
		/// <summary>
		/// PaidResearchCollection = 'r'
		/// </summary>
		PaidResearchCollection = 'r',
		/// <summary>
		/// PaidSourceCollection = 's'
		/// </summary>
		PaidSourceCollection = 's',
		/// <summary>
		/// AutologousEligibleForCrossover = 'A'
		/// </summary>
		AutologousEligibleForCrossover = 'A',
		/// <summary>
		/// ForAutologousUseOnly = '1'
		/// </summary>
		ForAutologousUseOnly = '1',
		/// <summary>
		/// ForAutologousUseOnlyBiohazardous = 'X'
		/// </summary>
		ForAutologousUseOnlyBiohazardous = 'X',
		/// <summary>
		/// VolunteerDirectedEligibeForCrossover = 'D'
		/// </summary>
		VolunteerDirectedEligibeForCrossover = 'D',
		/// <summary>
		/// PaidDirectedEligibleForCrossover = 'd'
		/// </summary>
		PaidDirectedEligibleForCrossover = 'd',
		/// <summary>
		/// ForDirectedDonorUseOnly = '2'
		/// </summary>
		ForDirectedDonorUseOnly = '2',
		/// <summary>
		/// ForDirectedDonorUseOnlyLimitedExposure = 'L'
		/// </summary>
		ForDirectedDonorUseOnlyLimitedExposure = 'L',
		/// <summary>
		/// ForDirectedDonorUseOnlyMedicalException = 'E'
		/// </summary>
		ForDirectedDonorUseOnlyMedicalException = 'E',
		/// <summary>
		/// SeeSpecialTestingBarcode = 'Q'
		/// </summary>
		SeeSpecialTestingBarcode = 'Q',
		/// <summary>
		/// ForDirectedDonorUseOnlyBiohazardous = '3'
		/// </summary>
		ForDirectedDonorUseOnlyBiohazardous = '3',
		/// <summary>
		/// DesignatedDonor = '4'
		/// </summary>
		DesignatedDonor = '4',
		/// <summary>
		/// DedicatedDonor = '5'
		/// </summary>
		DedicatedDonor = '5',
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue
	};
	/// <summary>
	/// DonationTypeId
	/// </summary>
	public enum DonationTypeId
	{
		/// <summary>
		/// NotSpecified=1
		/// </summary>
		NotSpecified=1,
		/// <summary>
		/// VolunteerAllogeneicDonor = 2
		/// </summary>
		VolunteerAllogeneicDonor = 2,
		/// <summary>
		/// VolunteerResearchDonor = 3
		/// </summary>
		VolunteerResearchDonor = 3,
		/// <summary>
		/// VolunteerSourceDonor = 4
		/// </summary>
		VolunteerSourceDonor = 4,
		/// <summary>
		/// VolunteerTherapeuticCollection = 5
		/// </summary>
		VolunteerTherapeuticCollection = 5,
		/// <summary>
		/// PaidAllogeneicCollection = 6
		/// </summary>
		PaidAllogeneicCollection = 6,
		/// <summary>
		/// PaidResearchCollection = 7
		/// </summary>
		PaidResearchCollection = 7,
		/// <summary>
		/// PaidSourceCollection = 8
		/// </summary>
		PaidSourceCollection = 8,
		/// <summary>
		/// AutologousEligibleForCrossover = 9
		/// </summary>
		AutologousEligibleForCrossover = 9,
		/// <summary>
		/// ForAutologousUseOnly = 10
		/// </summary>
		ForAutologousUseOnly = 10,
		/// <summary>
		/// ForAutologousUseOnlyBiohazardous = 11
		/// </summary>
		ForAutologousUseOnlyBiohazardous = 11,
		/// <summary>
		/// VolunteerDirectedEligibeForCrossover = 12
		/// </summary>
		VolunteerDirectedEligibeForCrossover = 12,
		/// <summary>
		/// PaidDirectedEligibleForCrossover = 13
		/// </summary>
		PaidDirectedEligibleForCrossover = 13,
		/// <summary>
		/// ForDirectedDonorUseOnly = 14
		/// </summary>
		ForDirectedDonorUseOnly = 14,
		/// <summary>
		/// ForDirectedDonorUseOnlyLimitedExposure = 15
		/// </summary>
		ForDirectedDonorUseOnlyLimitedExposure = 15,
		/// <summary>
		/// ForDirectedDonorUseOnlyMedicalException = 16
		/// </summary>
		ForDirectedDonorUseOnlyMedicalException = 16,
		/// <summary>
		/// SeeSpecialTestingBarcode = 17
		/// </summary>
		SeeSpecialTestingBarcode = 17,
		/// <summary>
		/// ForDirectedDonorUseOnlyBiohazardous = 18
		/// </summary>
		ForDirectedDonorUseOnlyBiohazardous = 18,
		/// <summary>
		/// DesignatedDonor = 19
		/// </summary>
		DesignatedDonor = 19,
		/// <summary>
		/// DedicatedDonor = 20
		/// </summary>
		DedicatedDonor = 20,
		/// <summary>
		/// Unknown = char.MinValue
		/// </summary>
		Unknown = char.MinValue
	};
	/// <summary>
	/// Inspection
	/// </summary>
	public enum Inspection
	{
		/// <summary>
		/// Satisfactory
		/// </summary>
		Satisfactory,
		/// <summary>
		/// UnSatisfactory
		/// </summary>
		UnSatisfactory
	};
	/// <summary>
	/// ProductType
	/// </summary>
	public enum ProductType
	{
		/// <summary>
		/// WholeBlood = 1
		/// </summary>
		WholeBlood = 1,
		/// <summary>
		/// RedBloodCells = 2
		/// </summary>
		RedBloodCells = 2,
		/// <summary>
		/// WashedRedBloodCells = 3
		/// </summary>
		WashedRedBloodCells = 3,
		/// <summary>
		/// FrozenRedBloodCells = 4
		/// </summary>
		FrozenRedBloodCells = 4,
		/// <summary>
		/// FrozenRejuvenatedRedBloodCells = 5
		/// </summary>
		FrozenRejuvenatedRedBloodCells = 5,
		/// <summary>
		/// DeglycerolizedRedBloodCells = 6
		/// </summary>
		DeglycerolizedRedBloodCells = 6,
		/// <summary>
		/// DeglycerolizedRejuvenatedRedBloodCells = 7
		/// </summary>
		DeglycerolizedRejuvenatedRedBloodCells = 7,
		/// <summary>
		/// RejuvenatedRedBloodCells = 8
		/// </summary>
		RejuvenatedRedBloodCells = 8,
		/// <summary>
		/// ApheresisRedBloodCells = 9
		/// </summary>
		ApheresisRedBloodCells = 9,
		/// <summary>
		/// FreshFrozenPlasma = 10
		/// </summary>
		FreshFrozenPlasma = 10,
		/// <summary>
		/// ThawedFreshFrozenPlasma = 11
		/// </summary>
		ThawedFreshFrozenPlasma = 11,
		/// <summary>
		/// ApheresisFreshFrozenPlasma = 12
		/// </summary>
		ApheresisFreshFrozenPlasma = 12,
		/// <summary>
		/// ThawedApheresisFreshFrozenPlasma = 13
		/// </summary>
		ThawedApheresisFreshFrozenPlasma = 13,
		/// <summary>
		/// ApheresisPlasma = 14
		/// </summary>
		ApheresisPlasma = 14,
		/// <summary>
		/// ThawedApheresisPlasma = 15
		/// </summary>
		ThawedApheresisPlasma = 15,
		/// <summary>
		/// LiquidPlasma = 16
		/// </summary>
		LiquidPlasma = 16,
		/// <summary>
		/// Plasma = 17
		/// </summary>
		Plasma = 17,
		/// <summary>
		/// ThawedPlasma = 18
		/// </summary>
		ThawedPlasma = 18,
		/// <summary>
		/// PlateletRichPlasma = 19
		/// </summary>
		PlateletRichPlasma = 19,
		/// <summary>
		/// Platelets = 20
		/// </summary>
		Platelets = 20,
		/// <summary>
		/// WashedPlatelets = 21
		/// </summary>
		WashedPlatelets = 21,
		/// <summary>
		/// PooledPlatelets = 22
		/// </summary>
		PooledPlatelets = 22,
		/// <summary>
		/// WashedPooledPlatelets = 23
		/// </summary>
		WashedPooledPlatelets = 23,
		/// <summary>
		/// ApheresisPlatelets = 24
		/// </summary>
		ApheresisPlatelets = 24,
		/// <summary>
		/// FrozenApheresisPlatelets = 25
		/// </summary>
		FrozenApheresisPlatelets = 25,
		/// <summary>
		/// ThawedApheresisPlatelets = 26
		/// </summary>
		ThawedApheresisPlatelets = 26,
		/// <summary>
		/// WashedApheresisPlatelets = 27
		/// </summary>
		WashedApheresisPlatelets = 27,
		/// <summary>
		/// Cryoprecipitate = 28
		/// </summary>
		Cryoprecipitate = 28,
		/// <summary>
		/// ThawedCryoprecipitate = 29
		/// </summary>
		ThawedCryoprecipitate = 29,
		/// <summary>
		/// PooledCryoprecipitate = 30
		/// </summary>
		PooledCryoprecipitate = 30,
		/// <summary>
		/// ThawedPooledCryoprecipitate = 31
		/// </summary>
		ThawedPooledCryoprecipitate = 31,
		/// <summary>
		/// ApheresisCryoprecipitate = 32
		/// </summary>
		ApheresisCryoprecipitate = 32,
		/// <summary>
		/// ThawedApheresisCryoprecipitate = 33
		/// </summary>
		ThawedApheresisCryoprecipitate = 33,
		/// <summary>
		/// Granulocytes = 34
		/// </summary>
		Granulocytes = 34,
		/// <summary>
		/// ApheresisGranulocytes = 35
		/// </summary>
		ApheresisGranulocytes = 35,
		/// <summary>
		/// PooledGranulocytes = 36
		/// </summary>
		PooledGranulocytes = 36,
		/// <summary>
		/// ApheresisGranulocytesPlatelets = 37
		/// </summary>
		ApheresisGranulocytesPlatelets = 37,
		/// <summary>
		/// Leukocytes = 38
		/// </summary>
		Leukocytes = 38,
		/// <summary>
		/// ApheresisLeukocytes = 39
		/// </summary>
		ApheresisLeukocytes = 39,
		/// <summary>
		/// PooledPlasma = 40
		/// </summary>
		PooledPlasma = 40,
		/// <summary>
		/// LiquidApheresisPlasma = 41
		/// </summary>
		LiquidApheresisPlasma = 41,
		/// <summary>
		/// PlateletRichBuffyCoat = 42
		/// </summary>
		PlateletRichBuffyCoat = 42,
		/// <summary>
		/// PooledPlateletRichBuffyCoat = 43
		/// </summary>
		PooledPlateletRichBuffyCoat = 43,
		/// <summary>
		/// ApheresisLymphocytes = 44
		/// </summary>
		ApheresisLymphocytes = 44,
		/// <summary>
		/// ApheresisMonocytes = 45
		/// </summary>
		ApheresisMonocytes = 45,
		/// <summary>
		/// Serum = 46
		/// </summary>
		Serum = 46,
		/// <summary>
		/// PooledSerum = 47
		/// </summary>
		PooledSerum = 47,
		/// <summary>
		/// FrozenPooledSerum = 48
		/// </summary>
		FrozenPooledSerum = 48,
		/// <summary>
		/// WashedApheresisRedBloodCells = 49
		/// </summary>
		WashedApheresisRedBloodCells = 49,
		/// <summary>
		/// FrozenApheresisRedBloodCells = 50
		/// </summary>
		FrozenApheresisRedBloodCells = 50,
		/// <summary>
		/// DeglycerolizedApheresisRedBloodCells = 51
		/// </summary>
		DeglycerolizedApheresisRedBloodCells = 51,
		/// <summary>
		/// RejuvenatedApheresisRedBloodCells
		/// </summary>
		RejuvenatedApheresisRedBloodCells = 52,
		/// <summary>
		/// FrozenRejuvenatedApheresisRedBloodCells
		/// </summary>
		FrozenRejuvenatedApheresisRedBloodCells = 53,
		/// <summary>
		/// DeglycerolizedRejuvenatedApheresisRedBloodCells
		/// </summary>
		DeglycerolizedRejuvenatedApheresisRedBloodCells = 54
	};
	/// <summary>
	/// ReactivityPhase
	/// </summary>
	public enum ReactivityPhase
	{
		/// <summary>
		/// Unknown = 0
		/// </summary>
		Unknown = 0,
		/// <summary>
		/// IS = 1
		/// </summary>
		IS = 1,
		/// <summary>
		/// IAT = 2
		/// </summary>
		IAT = 2,
		/// <summary>
		/// ISandIAT = 3
		/// </summary>
		ISandIAT = 3,
		/// <summary>
		/// ISandRT = 4
		/// </summary>
		ISandRT = 4,
		/// <summary>
		/// ISand37 = 5
		/// </summary>
		ISand37 = 5,
		/// <summary>
		/// AHGandCC = 6
		/// </summary>
		AHGandCC = 6,
		/// <summary>
		/// CC =7
		/// </summary>
		CC =7,
		/// <summary>
		/// ThreeSevenandAHG = 8
		/// </summary>
		ThreeSevenandAHG = 8,
		/// <summary>
		/// All = 9
		/// </summary>
		All = 9
	};
	/// <summary>
	/// Weld
	/// </summary>
	public enum Weld
	{
		/// <summary>
		/// Complete = 1
		/// </summary>
		Complete = 1,
		/// <summary>
		/// Incomplete = 0
		/// </summary>
		Incomplete = 0,
		/// <summary>
		/// Unknown = int.MinValue
		/// </summary>
		Unknown = int.MinValue
	};

	/// <summary>
	/// Code to determine the severity of a BR or validation check
	/// </summary>
	public enum VerifyAction
	{
		/// <summary>
		/// Cancel
		/// </summary>
		Cancel,
		/// <summary>
		/// Warning
		/// </summary>
		Warning,
		/// <summary>
		/// OverrideBiohazard
		/// </summary>
		OverrideBiohazard,
		/// <summary>
		/// OverrideExpiration
		/// </summary>
		OverrideExpiration,
		/// <summary>
		/// Release
		/// </summary>
		Release,
		/// <summary>
		/// Continue
		/// </summary>
		Continue,
		/// <summary>
		/// Unknown = int.MinValue
		/// </summary>
		Unknown = int.MinValue
	};
	/// <summary>
	/// Sex
	/// </summary>
	public enum Sex
	{
		/// <summary>
		/// Male = 'M'
		/// </summary>
		Male = 'M',
		/// <summary>
		/// Female = 'F'
		/// </summary>
		Female = 'F',
		/// <summary>
		/// Unknown = 'U'
		/// </summary>
		Unknown = 'U'
	};
	/// <summary>
	/// ISBTScan
	/// </summary>
	public enum ISBTScan
	{
		/// <summary>
		/// ProductCode
		/// </summary>
		ProductCode,
		/// <summary>
		/// UnitId
		/// </summary>
		UnitId,
		/// <summary>
		/// ABORh
		/// </summary>
		ABORh,
		/// <summary>
		/// ExpirationDate
		/// </summary>
		ExpirationDate,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	};
	/// <summary>
	/// PatientTestingConfiguration
	/// </summary>
	public enum PatientTestingConfiguration
	{
		/// <summary>
		/// AntibodyOnly = 1
		/// </summary>
		AntibodyOnly = 1,
		/// <summary>
		/// AntibodyDAT = 2
		/// </summary>
		AntibodyDAT = 2,
		/// <summary>
		/// AntibodyAutocontrol = 3
		/// </summary>
		AntibodyAutocontrol = 3,
		/// <summary>
		/// Unknown = int.MinValue
		/// </summary>
		Unknown = int.MinValue
	};

	/// <summary>
	/// TransfusionReactionType
	/// </summary>
	public enum TransfusionReactionType
	{
		/// <summary>
		/// Anaphylaxis = 'A'
		/// </summary>
		Anaphylaxis = 'A',
		/// <summary>
		/// Circulatory = 'C'
		/// </summary>
		Circulatory = 'C',
		/// <summary>
		/// DelayedHemolytic = 'D'
		/// </summary>
		DelayedHemolytic = 'D',
		/// <summary>
		/// FebrileNonHemolytic = 'F'
		/// </summary>
		FebrileNonHemolytic = 'F',
		/// <summary>
		/// GraftVsHostDisease = 'G'
		/// </summary>
		GraftVsHostDisease = 'G',
		/// <summary>
		/// AcuteHemolytic = 'H'
		/// </summary>
		AcuteHemolytic = 'H',
		/// <summary>
		/// TransfusionRelatedAcuteLungInjury = 'L'
		/// </summary>
		TransfusionRelatedAcuteLungInjury = 'L',
		/// <summary>
		/// Other = 'O'
		/// </summary>
		Other = 'O',
		/// <summary>
		/// PostTransfusion = 'P'
		/// </summary>
		PostTransfusion = 'P',
		/// <summary>
		/// Uticaria = 'U'
		/// </summary>
		Uticaria = 'U',
		//CR 3179
		/// <summary>
		/// AcuteHemolysisNonABO
		/// </summary>
		AcuteHemolysisNonABO = 'J',
		/// <summary>
		/// CitrateToxicity
		/// </summary>
		CitrateToxicity = 'Q',
		/// <summary>
		/// UnrelatedToTransfusion
		/// </summary>
		UnrelatedToTransfusion = 'R',
		/// <summary>
		/// TransfusionRelatedMicrobialInfection
		/// </summary>
		TransfusionRelatedMicrobialInfection = 'Z',
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown = char.MinValue
	}

	/// <summary>
	/// TransfusionRequirementCategoryCode
	/// </summary>
	public enum TransfusionRequirementCategoryCode
	{
		/// <summary>
		/// ComponentRequirement = 1
		/// </summary>
		ComponentRequirement = 1,
		/// <summary>
		/// AntigenNegative = 2
		/// </summary>
		AntigenNegative = 2,
		/// <summary>
		/// AntibodyIdentified = 3
		/// </summary>
		AntibodyIdentified = 3,
		/// <summary>
		/// Unknown = int.MinValue
		/// </summary>
		Unknown = int.MinValue
	};
	/// <summary>
	/// SpecimenCannedCommentContext
	/// </summary>
	public enum SpecimenCannedCommentContext
	{
		/// <summary>
		/// None
		/// </summary>
		None,
		/// <summary>
		/// SpecimenGeneral
		/// </summary>
		SpecimenGeneral,
		/// <summary>
		/// SpecimenExtension
		/// </summary>
		SpecimenExtension,
		/// <summary>
		/// SpecimenUnacceptable
		/// </summary>
		SpecimenUnacceptable
	};
	/// <summary>
	/// TestingMethod
	/// </summary>
	public enum TestingMethod
    {
        /// <summary>
        /// AutomatedInstrument = 'A'
        /// </summary>
        AutomatedInstrument = 'A',
		/// <summary>
		/// Tube = 'T'
		/// </summary>
		Tube = 'T',
		/// <summary>
		/// Gel = 'G'
		/// </summary>
		Gel = 'G',
		/// <summary>
		/// Solid = 'S'
		/// </summary>
		Solid = 'S',
		/// <summary>
		/// Unknown = 'U'
		/// </summary>
		Unknown = 'U'
	};
	/// <summary>
	/// OrderStatus -this enumeration mirrors the OrderStatus reference table
	/// </summary>
	public enum OrderStatus
	{
		/// <summary>
		/// Accepted
		/// </summary>
		Accepted,
		/// <summary>
		/// Complete
		/// </summary>
		Complete,
		/// <summary>
		/// Hold
		/// </summary>
		Hold,
		/// <summary>
		/// Pending
		/// </summary>
		Pending,
		/// <summary>
		/// Cancelled
		/// </summary>
		Cancelled,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	};
	/// <summary>
	/// OrderUrgency - This enumeration mirrors the OrderUrgency reference table
	/// </summary>
	public enum OrderUrgency
	{
		/// <summary>
		/// ASAP
		/// </summary>
		ASAP,
		/// <summary>
		/// PreOp
		/// </summary>
		PreOp,
		/// <summary>
		/// Routine
		/// </summary>
		Routine,
		/// <summary>
		/// STAT
		/// </summary>
		STAT,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	};
	/// <summary>
	/// TaskStatus - This enumeration mirrors the TaskStatus reference table.
	/// </summary>
	public enum TaskStatus
	{
		/// <summary>
		/// Completed
		/// </summary>
		Completed,
		/// <summary>
		/// Expired
		/// </summary>
		Expired,
		/// <summary>
		/// Filled
		/// </summary>
		Filled,
		/// <summary>
		/// InProgress
		/// </summary>
		InProgress,
		/// <summary>
		/// NotStarted
		/// </summary>
		NotStarted,
		/// <summary>
		/// PartiallyCompleted
		/// </summary>
		PartiallyCompleted,
		/// <summary>
		/// ResultsCorrected
		/// </summary>
		ResultsCorrected,
        /// <summary>
        /// PendingReview
        /// </summary>
        PendingReview,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	};
	/// <summary>
	/// SpecimenStatus - This enumeration mirrors the SpecimenStatus reference table.
	/// </summary>
	public enum SpecimenStatus
	{
		/// <summary>
		/// InBloodBank
		/// </summary>
		InBloodBank,
		/// <summary>
		/// ConvertedFromVista
		/// </summary>
		ConvertedFromVista,
		/// <summary>
		/// NSR
		/// </summary>
		NSR,
		/// <summary>
		/// Required
		/// </summary>
		Required,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	};
	/// <summary>
	/// DATTestControls - reagent type ids for reagents and controls used for DAT testing
	/// </summary>
	public enum DATTestControls
	{
		/// <summary>
		/// PSDAT = 59
		/// </summary>
		PSDAT = 59,
		/// <summary>
		/// PSDATPosControl = 56
		/// </summary>
		PSDATPosControl = 56,
		/// <summary>
		/// PSDATNegControl = 63
		/// </summary>
		PSDATNegControl = 63,
		/// <summary>
		/// IgGDAT = 54
		/// </summary>
		IgGDAT = 54,
		/// <summary>
		/// IgGDATPosControl = 56
		/// </summary>
		IgGDATPosControl = 56,
		/// <summary>
		/// IgGDATNegControl = 63
		/// </summary>
		IgGDATNegControl = 63,
		/// <summary>
		/// CompDAT = 51
		/// </summary>
		CompDAT = 51,
		/// <summary>
		/// CompDATPosControl = 55
		/// </summary>
		CompDATPosControl = 55,
		/// <summary>
		/// CompDATNegControl = 63
		/// </summary>
		CompDATNegControl = 63
	};
	/// <summary>
	/// OrderableTest
    /// Defect 286852 - Added all OrderableTest enums to be in sync with the db
	/// </summary>
	public enum OrderableTest
	{
		/// <summary>
		/// ABORh = 1
		/// </summary>
		ABORh = 1,
		/// <summary>
		/// ABS = 3
		/// </summary>
		ABS = 3,
		/// <summary>
		/// DAT = 4
		/// </summary>
		DAT = 4,
		/// <summary>
		/// DATIgG = 5
		/// </summary>
		DATIgG = 5,
		/// <summary>
		/// DATComp = 6
		/// </summary>
		DATComp = 6,
		/// <summary>
		/// TAS = 7
		/// </summary>
		TAS = 7,
		/// <summary>
		/// ABID = 8
		/// </summary>
		ABID = 8,
		/// <summary>
		/// XM = 9
		/// </summary>
		XM = 9,
		/// <summary>
		/// TRW = 10
		/// </summary>
		TRW = 10,
		/// <summary>
		/// AGwD = 11
		/// </summary>
		AGwD = 11,
		/// <summary>
		/// AGC = 12
		/// </summary>
		AGC = 12,
		/// <summary>
		/// AGE = 13
		/// </summary>
		AGE = 13,
		/// <summary>
		/// AGc = 14
		/// </summary>
		AGc = 14,
		/// <summary>
		/// AGe = 15
		/// </summary>
		AGe = 15,
		/// <summary>
		/// AGk = 21
		/// </summary>
		AGk = 21,
		/// <summary>
		/// AGK = 20
		/// </summary>
		AGK = 20,
		/// <summary>
		/// AGKpa = 22
		/// </summary>
		AGKpa = 22,
		/// <summary>
		/// AGKpb = 23
		/// </summary>
		AGKpb = 23,
		/// <summary>
		/// AGJka = 24
		/// </summary>
		AGJka = 24,
		/// <summary>
		/// AGJkb = 25
		/// </summary>
		AGJkb = 25,
		/// <summary>
		/// AGFya = 28
		/// </summary>
		AGFya = 28,
		/// <summary>
		/// AGFyb = 29
		/// </summary>
		AGFyb = 29,
		/// <summary>
		/// AGM = 30
		/// </summary>
		AGM = 30,
		/// <summary>
		/// AGN = 31
		/// </summary>
		AGN = 31,
		/// <summary>
		/// AGS = 32
		/// </summary>
		AGS = 32,
		/// <summary>
		/// AGs = 33
		/// </summary>
		AGs = 33,
		/// <summary>
		/// AGU = 34
		/// </summary>
		AGU = 34,
		/// <summary>
		/// AGP1 = 35
		/// </summary>
		AGP1 = 35,
		/// <summary>
		/// AGLea = 37
		/// </summary>
		AGLea = 37,
		/// <summary>
		/// AGLeb = 38
		/// </summary>
		AGLeb = 38,
		/// <summary>
		/// AGJsa = 39
		/// </summary>
		AGJsa = 39,
		/// <summary>
		/// AGJsb = 40
		/// </summary>
		AGJsb = 40,
		/// <summary>
		/// AGLua = 41
		/// </summary>
		AGLua = 41,
		/// <summary>
		/// AGLub = 42
		/// </summary>
		AGLub = 42,
		/// <summary>
		/// AGCw = 45
		/// </summary>
		AGCw = 45,
		/// <summary>
		/// AGXgA = 48
		/// </summary>
		AGXgA = 48,
		/// <summary>
		/// AGP = 49
		/// </summary>
		AGP = 49,
		/// <summary>
		/// AGA1 = 51
		/// </summary>
		AGA1 = 51,
		/// <summary>
		/// AGDia = 54
		/// </summary>
		AGDia = 54,
		/// <summary>
		/// AGDib = 55
		/// </summary>
		AGDib = 55,
		/// <summary>
		/// AGSc1 = 57
		/// </summary>
		AGSc1 = 57,
		/// <summary>
		/// AGSc2 = 58
		/// </summary>
		AGSc2 = 58,
		/// <summary>
		/// AGYta = 59
		/// </summary>
		AGYta = 59,
		/// <summary>
		/// AGYtb = 60
		/// </summary>
		AGYtb = 60,
		/// <summary>
		/// RepeatAGwD = 61
		/// </summary>
		RepeatAGwD = 61,
		/// <summary>
		/// RepeatAGC = 62
		/// </summary>
		RepeatAGC = 62,
		/// <summary>
		/// RepeatAGE = 63
		/// </summary>
		RepeatAGE = 63,
		/// <summary>
		/// RepeatAGc = 64
		/// </summary>
		RepeatAGc = 64,
		/// <summary>
		/// RepeatAGe = 65
		/// </summary>
		RepeatAGe = 65,
		/// <summary>
		/// RepeatAGK = 70
		/// </summary>
		RepeatAGK = 70,
		/// <summary>
		/// RepeatAGk = 71
		/// </summary>
		RepeatAGk = 71,
		/// <summary>
		/// RepeatAGKpa = 72
		/// </summary>
		RepeatAGKpa = 72,
		/// <summary>
		/// RepeatAGKpb = 73
		/// </summary>
		RepeatAGKpb = 73,
		/// <summary>
		/// RepeatAGJka = 74
		/// </summary>
		RepeatAGJka = 74,
		/// <summary>
		/// RepeatAGJkb = 75
		/// </summary>
		RepeatAGJkb = 75,
		/// <summary>
		/// RepeatAGFya = 78
		/// </summary>
		RepeatAGFya = 78,
		/// <summary>
		/// RepeatAGFyb = 79
		/// </summary>
		RepeatAGFyb = 79,
		/// <summary>
		/// RepeatAGM = 80
		/// </summary>
		RepeatAGM = 80,
		/// <summary>
		/// RepeatAGN = 81
		/// </summary>
		RepeatAGN = 81,
		/// <summary>
		/// RepeatAGS = 82
		/// </summary>
		RepeatAGS = 82,
		/// <summary>
		/// RepeatAGs = 83
		/// </summary>
		RepeatAGs = 83,
		/// <summary>
		/// RepeatAGU = 84
		/// </summary>
		RepeatAGU = 84,
		/// <summary>
		/// RepeatAGP1 = 85
		/// </summary>
		RepeatAGP1 = 85,
		/// <summary>
		/// RepeatAGLea = 87
		/// </summary>
		RepeatAGLea = 87,
		/// <summary>
		/// RepeatAGLeb = 88
		/// </summary>
		RepeatAGLeb = 88,
		/// <summary>
		/// RepeatAGJsa = 89
		/// </summary>
		RepeatAGJsa = 89,
		/// <summary>
		/// RepeatAGJsb = 90
		/// </summary>
		RepeatAGJsb = 90,
		/// <summary>
		/// RepeatAGLua = 91
		/// </summary>
		RepeatAGLua = 91,
		/// <summary>
		/// RepeatAGLub = 92
		/// </summary>
		RepeatAGLub = 92,
		/// <summary>
		/// RepeatAGCw =  95
		/// </summary>
		RepeatAGCw =  95,
		/// <summary>
		/// RepeatAGXgA = 98
		/// </summary>
		RepeatAGXgA = 98,
		/// <summary>
		/// RepeatAGP = 99
		/// </summary>
		RepeatAGP = 99,
		/// <summary>
		/// RepeatAGA1 = 101
		/// </summary>
		RepeatAGA1 = 101,
		/// <summary>
		/// RepeatAGDia = 104
		/// </summary>
		RepeatAGDia = 104,
		/// <summary>
		/// RepeatAGDib = 105
		/// </summary>
		RepeatAGDib = 105,
		/// <summary>
		/// RepeatAGSc1 = 107
		/// </summary>
		RepeatAGSc1 = 107,
		/// <summary>
		/// RepeatAGSc2 = 108
		/// </summary>
		RepeatAGSc2 = 108,
		/// <summary>
		/// RepeatAGYta = 109
		/// </summary>
		RepeatAGYta = 109,
		/// <summary>
		/// RepeatAGYtb = 110
		/// </summary>
		RepeatAGYtb = 110,
		/// <summary>
		/// RepeatABORh = 111
		/// </summary>
		RepeatABORh = 111,
		/// <summary>
		/// RepeatABS = 113
		/// </summary>
		RepeatABS = 113,
		/// <summary>
		/// RepeatDAT = 114
		/// </summary>
		RepeatDAT = 114,
		/// <summary>
		/// RepeatDATlgG = 115
		/// </summary>
		RepeatDATIgG = 115,
		/// <summary>
		/// RepeatDATComp = 116
		/// </summary>
		RepeatDATComp = 116,
		/// <summary>
		/// RepeatABID = 118
		/// </summary>
		RepeatABID = 118,
		/// <summary>
		/// RepeatXM = 119
		/// </summary>
        RepeatXM = 119,
        /// <summary>
        /// AGCx = 201
        /// </summary>
        AGCx = 201,
        /// <summary>
        /// AGEw = 202
        /// </summary>
        AGEw = 202,
        /// <summary>
        /// AGV = 203
        /// </summary>
        AGV = 203,
        /// <summary>
        /// AGMg = 204
        /// </summary>
        AGMg = 204,
        /// <summary>
        /// AGMia = 205
        /// </summary>
        AGMia = 205,
        /// <summary>
        /// AGH = 206
        /// </summary>
        AGH = 206,
        /// <summary>
        /// AGDoa = 207
        /// </summary>
        AGDoa = 207,
        /// <summary>
        /// AGDob = 208
        /// </summary>
        AGDob = 208,
        /// <summary>
        /// AGCoa = 209
        /// </summary>
        AGCoa = 209,
        /// <summary>
        /// AGCob = 210
        /// </summary>
        AGCob = 210,
        /// <summary>
        /// AGLWa = 211
        /// </summary>
        AGLWa = 211,
        /// <summary>
        /// AGLWb = 212
        /// </summary>
        AGLWb = 212,
        /// <summary>
        /// AGSda = 213
        /// </summary>
        AGSda = 213,
        /// <summary>
        /// AGAua = 214
        /// </summary>
        AGAua = 214,
        /// <summary>
        /// AGAub = 215
        /// </summary>
        AGAub = 215,
        /// <summary>
        /// AGCh = 216
        /// </summary>
        AGCh = 216,
        /// <summary>
        /// AGRg = 217
        /// </summary>
        AGRg = 217,
        /// <summary>
        /// AGCsa = 218
        /// </summary>
        AGCsa = 218,
        /// <summary>
        /// AGYka = 219
        /// </summary>
        AGYka = 219,
        /// <summary>
        /// AGKna = 220
        /// </summary>
        AGKna = 220,
        /// <summary>
        /// AGMcCa = 221
        /// </summary>
        AGMcCa = 221,
        /// <summary>
        /// AGJMH = 222
        /// </summary>
        AGJMH = 222,
        /// <summary>
        /// RepeatAGCx = 301
        /// </summary>
        RepeatAGCx = 301,
        /// <summary>
        /// RepeatAGEw = 302
        /// </summary>
        RepeatAGEw = 302,
        /// <summary>
        /// RepeatAGV = 303
        /// </summary>
        RepeatAGV = 303,
        /// <summary>
        /// RepeatAGMg = 304
        /// </summary>
        RepeatAGMg = 304,
        /// <summary>
        /// RepeatAGMia = 305
        /// </summary>
        RepeatAGMia = 305,
        /// <summary>
        /// RepeatAGH = 306
        /// </summary>
        RepeatAGH = 306,
        /// <summary>
        /// RepeatAGDoa = 307
        /// </summary>
        RepeatAGDoa = 307,
        /// <summary>
        /// RepeatAGDob = 308
        /// </summary>
        RepeatAGDob = 308,
        /// <summary>
        /// RepeatAGCoa = 309
        /// </summary>
        RepeatAGCoa = 309,
        /// <summary>
        /// RepeatAGCob = 310
        /// </summary>
        RepeatAGCob = 310,
        /// <summary>
        /// RepeatAGLWa = 311
        /// </summary>
        RepeatAGLWa = 311,
        /// <summary>
        /// RepeatAGLWb = 312
        /// </summary>
        RepeatAGLWb = 312,
        /// <summary>
        /// RepeatAGSda = 313
        /// </summary>
        RepeatAGSda = 313,
        /// <summary>
        /// RepeatAGAua = 314
        /// </summary>
        RepeatAGAua = 314,
        /// <summary>
        /// RepeatAGAub = 315
        /// </summary>
        RepeatAGAub = 315,
        /// <summary>
        /// RepeatAGCh = 316
        /// </summary>
        RepeatAGCh = 316,
        /// <summary>
        /// RepeatAGRg = 317
        /// </summary>
        RepeatAGRg = 317,
        /// <summary>
        /// RepeatAGCsa = 318
        /// </summary>
        RepeatAGCsa = 318,
        /// <summary>
        /// RepeatAGYka = 319
        /// </summary>
        RepeatAGYka = 319,
        /// <summary>
        /// RepeatAGKna = 320
        /// </summary>
        RepeatAGKna = 320,
        /// <summary>
        /// RepeatAGMcCa = 321
        /// </summary>
        RepeatAGMcCa = 321,
        /// <summary>
        /// RepeatAGJMH = 322
        /// </summary>
        RepeatAGJMH = 322
	};
	/// <summary>
	/// WeakDTestReagents
	/// </summary>
	public enum WeakDTestReagents
	{
		/// <summary>
		/// AntiD = 52
		/// </summary>
		AntiD = 52,
		/// <summary>
		/// AntiDControl = 53
		/// </summary>
		AntiDControl = 53
	};
	/// <summary>
	/// CrossmatchResult
	/// </summary>
	public enum CrossmatchResult
	{
		/// <summary>
		/// CompatibleEXM = 'E'
		/// </summary>
		CompatibleEXM = 'E',
		/// <summary>
		/// CompatibleSafeToTransfuse = 'C'
		/// </summary>
		CompatibleSafeToTransfuse = 'C',
		/// <summary>
		/// CompatibleDontTransfuse = 'D'
		/// </summary>
		CompatibleDontTransfuse = 'D',
		/// <summary>
		/// IncompatibleDirectorApprovalNeeded = 'G'
		/// </summary>
		IncompatibleDirectorApprovalNeeded = 'G',
		/// <summary>
		/// IncompatibleUnsafeToTransfuse = 'I'
		/// </summary>
		IncompatibleUnsafeToTransfuse = 'I',
		/// <summary>
		/// Inconclusive
		/// </summary>
		Inconclusive = 'Z',
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown

	};
	/// <summary>
	/// TestResult
	/// </summary>
	public enum TestResult
	{
		/// <summary>
		/// A
		/// </summary>
		A,
		/// <summary>
		/// AB
		/// </summary>
		AB,
		/// <summary>
		/// B
		/// </summary>
		B,
		/// <summary>
		/// F
		/// </summary>
		F,
		/// <summary>
		/// H
		/// </summary>
		H,
		/// <summary>
		/// I
		/// </summary>
		I,
		/// <summary>
		/// M
		/// </summary>
		M,
		/// <summary>
		/// N
		/// </summary>
		N,
		/// <summary>
		/// O
		/// </summary>
		O,
		/// <summary>
		/// P
		/// </summary>
		P,
		/// <summary>
		/// R
		/// </summary>
		R,
		/// <summary>
		/// W
		/// </summary>
		W,
		/// <summary>
		/// X
		/// </summary>
		X,
		/// <summary>
		/// C
		/// </summary>
		C,
		/// <summary>
		/// D
		/// </summary>
		D,
		/// <summary>
		/// G
		/// </summary>
		G,
		/// <summary>
		/// Z
		/// </summary>
		Z,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	};
	/// <summary>
	/// UC03UnitSelectErrorMessages
	/// This enumeration contains a list of all possible errors (that have a
	/// corresponding user error message) that can be generated at time of unit
	/// selection.  They are organized in the order that they should be applied
	/// as directed by the SMEs.
	/// </summary>
	public enum UC03UnitSelectErrorMessages
	{
		/// <summary>
		/// AlreadySelectedForThisPatient
		/// </summary>
		AlreadySelectedForThisPatient,
		/// <summary>
		/// BR301Specimen
		/// </summary>
		BR301Specimen,
		/// <summary>
		/// BR330SpecimenResults
		/// </summary>
		BR330SpecimenResults,
		/// <summary>
		/// BR324
		/// </summary>
		BR324,
		/// <summary>
		/// BR340SpecimenResults
		/// </summary>
		BR340SpecimenResults,
		/// <summary>
		/// BR319UnitExpired
		/// </summary>
		BR319UnitExpired,
		/// <summary>
		/// BR319UnitExpiredOverride
		/// </summary>
		BR319UnitExpiredOverride,
		/// <summary>
		/// BR319UnitNotInSameDivision
		/// </summary>
		BR319UnitNotInSameDivision,
		/// <summary>
		/// BR341ABOInconclusive
		/// </summary>
		BR341ABOInconclusive,
		/// <summary>
		/// BR316ABORhConfirmation
		/// </summary>
		BR316ABORhConfirmation,
		/// <summary>
		/// BR333InvalidProductType
		/// </summary>
		BR333InvalidProductType,
		/// <summary>
		/// BR344NotInBloodBank
		/// </summary>
		BR344NotInBloodBank,
		/// <summary>
		/// BR313AlreadySelected
		/// </summary>
		BR313AlreadySelected,
		/// <summary>
		/// BR323UnitIncompatible
		/// </summary>
		BR323UnitIncompatible,
		/// <summary>
		/// BR343UnitQuarantined
		/// </summary>
		BR343UnitQuarantined,
		/// <summary>
		/// BR345OutgoingShipment
		/// </summary>
		BR345OutgoingShipment,
		/// <summary>
		/// BR346UnitRestricted
		/// </summary>
		BR346UnitRestricted,
		/// <summary>
		/// UnitNotCompatible
		/// </summary>
		UnitNotCompatible,
		/// <summary>
		/// BR305NoABORhResults
		/// </summary>
		BR305NoABORhResults,
		/// <summary>
		/// BR310
		/// </summary>
		BR310,
		/// <summary>
		/// BR310Override
		/// </summary>
		BR310Override,
		/// <summary>
		/// BR306
		/// </summary>
		BR306,
		/// <summary>
		/// BR306Override
		/// </summary>
		BR306Override,
		/// <summary>
		/// BR315UnitNotTyped
		/// </summary>
		BR315UnitNotTyped,
		/// <summary>
		/// BR321
		/// </summary>
		BR321,
		/// <summary>
		/// BR321Female
		/// </summary>
		BR321Female,
		/// <summary>
		/// BR349
		/// </summary>
		BR349,
		/// <summary>
		/// BR314TransfusionRequirements
		/// </summary>
		BR314TransfusionRequirements,
		/// <summary>
		/// BR332CMVNegRequired
		/// </summary>
		BR332CMVNegRequired,
		/// <summary>
		/// BR332CMVNegRequiredOverride
		/// </summary>
		BR332CMVNegRequiredOverride,
		/// <summary>
        /// BR332SickleCellAndCMVNegRequired
        /// </summary>
        BR332SickleCellAndCMVNegRequired,
        /// <summary>
        /// BR332SickleCellAndCMVNegRequiredOverride
        /// </summary>
        BR332SickleCellAndCMVNegRequiredOverride,
        /// <summary>
        /// BR332SickleCellNegRequired
        /// </summary>
        BR332SickleCellNegRequired,
        /// <summary>
        /// BR332SickleCellNegRequiredOverride
        /// </summary>
        BR332SickleCellNegRequiredOverride,
        /// <summary>
		/// BR334RestrictiveUnits
		/// </summary>
		BR334RestrictiveUnits,
		/// <summary>
		/// BR339BiohazardousWarningIndicator
		/// </summary>
		BR339BiohazardousWarningIndicator,
		/// <summary>
		/// BR328AssignedToAnotherPatient
		/// </summary>
		BR328AssignedToAnotherPatient,
		/// <summary>
		/// BR311NoABORhResults
		/// </summary>
		BR311NoABORhResults,
		/// <summary>
		/// BR312UnitFrozen
		/// </summary>
		BR312UnitFrozen,
		/// <summary>
		/// BR312UnitFrozenEmergencyIssue
		/// </summary>
		BR312UnitFrozenEmergencyIssue,
		/// <summary>
		/// BR352JustifiedABORh
		/// </summary>
		BR352JustifiedABORh,
		/// <summary>
		/// MustEmergencyIssue
		/// </summary>
		MustEmergencyIssue,
		/// <summary>
		/// BadStatus
		/// </summary>
		BadStatus
	}
	/// <summary>
	/// From the AntibodyType table
	/// </summary>
	public enum Antibody
	{
		/// <summary>
		/// AntiA = 1
		/// </summary>
		AntiA = 1,
		/// <summary>
		/// AntiB = 4
		/// </summary>
		AntiB = 4,
		/// <summary>
		/// AntiD = 11
		/// </summary>
		AntiD = 11
	}
	/// <summary>
	/// From the AntigenType table
	/// </summary>
	public enum Antigen
	{
		/// <summary>
		/// AntiA = 1
		/// </summary>
		A = 1,
		/// <summary>
		/// AntiB = 5
		/// </summary>
		B = 5,
		/// <summary>
		/// AntiD = 15
		/// </summary>
		D = 15
	}
	/// <summary>
	/// Excluded from system generated reqs (TT_23.01C)
	/// </summary>
	public enum ExcludedAntigens
	{
		/// <summary>
		/// AntiA
		/// </summary>
		AntiA = 1,
		/// <summary>
		/// AntiB
		/// </summary>
		AntiB = 4,
		/// <summary>
		/// AntiIint
		/// </summary>
		AntiIint = 23,
		/// <summary>
		/// AntiLW
		/// </summary>
		AntiLW = 32,
		/// <summary>
		/// AntiLe_other
		/// </summary>
		AntiLe_other = 36,
		/// <summary>
		/// AntiLu
		/// </summary>
		AntiLu = 37,
		/// <summary>
		/// AntiM_other
		/// </summary>
		AntiM_other = 43,
		/// <summary>
		/// AntiN_other
		/// </summary>
		AntiN_other = 46,
		/// <summary>
		/// AntiP1_P_Pk
		/// </summary>
		AntiP1_P_Pk = 49,
		/// <summary>
		/// AntiPk
		/// </summary>
		AntiPk = 64,
		/// <summary>
		/// Antirhesus_other
		/// </summary>
		Antirhesus_other = 65,
		/// <summary>
		/// Antirhesus_NOS
		/// </summary>
		Antirhesus_NOS = 66
	}
	/// <summary>
	/// Excluded from system generated reqs (TT_23.01C)
	/// </summary>
	public enum ExcludedAntibodies
	{
		/// <summary>
		/// AntiA
		/// </summary>
		AntiA = 1,
		/// <summary>
		/// AntiB
		/// </summary>
		AntiB = 4,
		/// <summary>
		/// AntiIint
		/// </summary>
		AntiIint = 23,
		/// <summary>
		/// AntiLW
		/// </summary>
		AntiLW = 32,
		/// <summary>
		/// AntiLe_other
		/// </summary>
		AntiLe_other = 36,
		/// <summary>
		/// AntiLu
		/// </summary>
		AntiLu = 37,
		/// <summary>
		/// AntiM_other
		/// </summary>
		AntiM_other = 43,
		/// <summary>
		/// AntiN_other
		/// </summary>
		AntiN_other = 46,
		/// <summary>
		/// AntiP1_P_Pk
		/// </summary>
		AntiP1_P_Pk = 49,
		/// <summary>
		/// AntiPk
		/// </summary>
		AntiPk = 64,
		/// <summary>
		/// Antirhesus_other
		/// </summary>
		Antirhesus_other = 65,
		/// <summary>
		/// Antirhesus_NOS
		/// </summary>
		Antirhesus_NOS = 66
	}
	/// <summary>
	/// PatientABORhHistory
	/// </summary>
	public enum PatientABORhHistory
	{
		/// <summary>
		/// TestResultsInCurrentDivision = 2
		/// </summary>
		TestResultsInCurrentDivision = 2,
		/// <summary>
		/// TestResultsOutsideDivision = 1
		/// </summary>
		TestResultsOutsideDivision = 1,
		/// <summary>
		/// NoABORhResults = 0
		/// </summary>
		NoABORhResults = 0,
		/// <summary>
		/// From DB conversion
		/// </summary>
		FromConversion = 3
	}
	/// <summary>
	/// SpecimenExpirationDays
	/// </summary>
	public enum SpecimenExpirationDays
	{
		/// <summary>
		/// Default = 3
		/// </summary>
		Default = 3,
		/// <summary>
		/// Minimum = 3
		/// </summary>
		Minimum = 3,
		/// <summary>
		/// Maximum = 93
		/// </summary>
		Maximum = 93
	}	
	/// <summary>
	/// OrderAlertRefreshRate
	/// </summary>
	public enum OrderAlertRefreshRate
	{
		/// <summary>
		/// Default = 60
		/// </summary>
		Default = 60,
		/// <summary>
		/// Minimum = 5
		/// </summary>
		Minimum = 5,
		/// <summary>
		/// Maximum = 86400
		/// </summary>
		Maximum = 86400
	}
	/// <summary>
	/// MaximumTransfusionTime
	/// </summary>
	public enum MaximumTransfusionTime
	{
		/// <summary>
		/// Default = 270
		/// </summary>
		Default = 270,
		/// <summary>
		/// Minimum = 5
		/// </summary>
		Minimum = 5,
		/// <summary>
		/// Maximum = 999
		/// </summary>
		Maximum = 999
	}
	/// <summary>
	/// ExceptionReportType
	/// </summary>
	public enum ExceptionReportType
	{
		/// <summary>
		/// ExceptionReportLabelMismatch
		/// </summary>
		ExceptionReportLabelMismatch = 1,
		/// <summary>
		/// ExceptionReportPatientAboRh
		/// </summary>
		ExceptionReportPatientAboRh,
		/// <summary>
		/// ExceptionReportPatientAboRhDiscrepancy
		/// </summary>
		ExceptionReportPatientAboRhDiscrepancy,
		/// <summary>
		/// ExceptionReportPatientAntigenDiscrepancy
		/// </summary>
		ExceptionReportPatientAntigenDiscrepancy,
		/// <summary>
		/// ExceptionReportPatientTest
		/// </summary>
		ExceptionReportPatientTest,
		/// <summary>
		/// ExceptionReportPatientTestInactivated
		/// </summary>
		ExceptionReportPatientTestInactivated,
		/// <summary>
		/// ExceptionReportQC
		/// </summary>
		ExceptionReportQC,
		/// <summary>
		/// ExceptionReportQCInactivated
		/// </summary>
		ExceptionReportQCInactivated,
		/// <summary>
		/// ExceptionReportQCNotPerformed
		/// </summary>
		ExceptionReportQCNotPerformed,
		/// <summary>
		/// ExceptionReportQuarantine
		/// </summary>
		ExceptionReportQuarantine,
		/// <summary>
		/// ExceptionReportReflexTest
		/// </summary>
		ExceptionReportReflexTest,
		/// <summary>
		/// ExceptionReportSpecimen
		/// </summary>
		ExceptionReportSpecimen,
		/// <summary>
		/// ExceptionReportUnitAboRh
		/// </summary>
		ExceptionReportUnitAboRh,
		/// <summary>
		/// ExceptionReportUnitModification
		/// </summary>
		ExceptionReportUnitModification,
		/// <summary>
		/// ExceptionReportUnitSelection
		/// </summary>
		ExceptionReportUnitSelection,
		/// <summary>
		/// ExceptionReportMain
		/// </summary>
		ExceptionReportMain,
		/// <summary>
		/// ExceptionReportReturnIssuedUnit    
		/// </summary>
		ExceptionReportReturnIssuedUnit,
		/// <summary>
		/// ExceptionReportAboIncompatibleTransfusion    
		/// </summary>
		ExceptionReportAboIncompatibleTransfusion,
		/// <summary>
		/// ExceptionReportTransfusionReactionWorkup
		/// </summary>
		ExceptionReportTransfusionReactionWorkup,
		/// <summary>
		/// ExceptionReportExpiredUnitReceived     
		/// </summary>
		ExceptionReportExpiredUnitReceived,
		/// <summary>
		/// ExceptionReportCautionTagBTRFPrinting     
		/// </summary>
		ExceptionReportCautionTagBTRFPrinting,
		/// <summary>
		/// ExceptionReportTrwSpecimen
		/// </summary>
		ExceptionReportTrwSpecimen,
		/// <summary>
		/// ExceptionReportAntigenTest
		/// </summary>
		ExceptionReportAntigenTest,
		/// <summary>
		/// ExceptionReportUnitTest
		/// </summary>
		ExceptionReportUnitTest,
		/// <summary>
		/// ExceptionReportTransfusion
		/// </summary>
		ExceptionReportTransfusion,
		/// <summary>
		/// ExceptionReportExpiredTaskProcessed
		/// </summary>
		ExceptionReportUnitERIssuedTestingProblem,
		/// <summary>
		/// ExceptionReportExpiredTaskProcessed
		/// </summary>
		ExceptionReportExpiredTaskProcessed,
		/// <summary>
		/// ExceptionReportUnitSupply
		/// </summary>
		ExceptionReportUnitSupply,
		/// <summary>
		/// ExceptionReportUnitIssue
		/// </summary>
		ExceptionReportUnitIssue,
		/// <summary>
		/// ExceptionReportPatientRestriction
		/// </summary>
		ExceptionReportPatientRestriction,
		/// <summary>
		/// ExceptionReportEmergencyIssueOrder
		/// </summary>
		ExceptionReportEmergencyIssueOrder,
		/// <summary>
		/// ExceptionReportRemoveFinalUnitStatus
		/// </summary>
		ExceptionReportRemoveFinalUnitStatus,
		/// <summary>
		/// ExceptionReportCrossmatch
		/// </summary>
		ExceptionReportCrossmatch,
		/// <summary>
		/// ExceptionReportElectronicTransfusion
		/// </summary>
		ExceptionReportElectronicTransfusion,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	}
	/// <summary>
	/// ExceptionType
	/// </summary>
	public enum ExceptionType
	{
		/// <summary>
		/// ABO_Rh_confirmation_does_not_match_login_ABO_Rh
		/// </summary>
		ABORh_confirmation_does_not_match_login_ABORh = 1,
		/// <summary>
		/// ABO_Rh_confirmation_inconclusive_unit_quarantined
		/// </summary>
		ABORh_confirmation_inconclusive_unit_quarantined = 2,
		/// <summary>
		/// Antigen_positive_unit_selected
		/// </summary>
		Antigen_positive_unit_selected = 3,
		/// <summary>
		/// ABO_incompatible_unit_selected
		/// </summary>
		ABO_incompatible_unit_selected = 4,
		/// <summary>
		/// Transfusion_requirement_incompatible_unit_selected
		/// </summary>
		Transfusion_requirement_incompatible_unit_selected = 5,
		/// <summary>
		/// Biohazardous_unit_selected
		/// </summary>
		Biohazardous_unit_selected = 6,
		/// <summary>
		/// Crossmatch_incompatible_Give_only_with_MD_approval
		/// </summary>
		Crossmatch_incompatible_Give_only_with_MD_approval = 7,
		/// <summary>
		/// Antigen_positive_unit_crossmatched
		/// </summary>
		Antigen_positive_unit_crossmatched = 8,
		/// <summary>
		/// Rh_positive_units_selected
		/// </summary>
		Rh_positive_units_selected = 9,
		/// <summary>
		/// Expired_unit_modified
		/// </summary>
		Expired_unit_modified = 10,
		/// <summary>
		/// Target_product_outdate_extended
		/// </summary>
		Target_product_outdate_extended = 11,
		/// <summary>
		/// Biohazardous_unit_modified
		/// </summary>
		Biohazardous_unit_modified = 12,
		/// <summary>
		/// Target_product_label_mismatch
		/// </summary>
		Target_product_label_mismatch = 13,
		/// <summary>
		/// Unit_quarantined
		/// </summary>
		Unit_quarantined = 14,
		/// <summary>
		/// Unit_discarded
		/// </summary>
		Unit_discarded = 15,
		/// <summary>
		/// Unit_released_from_quarantine
		/// </summary>
		Unit_released_from_quarantine = 16,
		/// <summary>
		/// Expired_unit_released_from_quarantine
		/// </summary>
		Expired_unit_released_from_quarantine = 17,
		/// <summary>
		/// Retrospective_update_prior_to_last_record_update
		/// </summary>
		Retrospective_update_prior_to_last_record_update = 18,
		/// <summary>
		/// Used for UC_01 when they ship a unit in that is expired     
		/// </summary>
		Expired_unit_received = 19,
		/// <summary>
		/// QC_decrease_reagent_reactivity = 20,
		/// </summary>
		QC_decrease_reagent_reactivity = 20,
		/// <summary>
		/// Expired_reagent_QC = 21,
		/// </summary>
		Expired_reagent_QC = 21,
		/// <summary>
		/// Expired_antisera_used = 22
		/// </summary>
		Expired_antisera_used = 22,
		/// <summary>
		/// Partially_completed_QC_deleted
		/// </summary>
		Partially_completed_QC_deleted = 23,
		/// <summary>
		/// Specimen_expiration_date_extended
		/// </summary>
		Specimen_expiration_date_extended = 24,
		/// <summary>
		/// Unacceptable_Expired_specimen_used
		/// </summary>
		Unacceptable_Expired_specimen_used = 25,
		/// <summary>
		/// Non_standard_test_procedure
		/// </summary>
		Non_standard_test_procedure = 26,
		/// <summary>
		/// Reflex_test_ordered_on_expired_specimen
		/// </summary>
		Reflex_test_ordered_on_expired_specimen = 27,
		/// <summary>
		/// Invalid_ABORh_typing_and_interpretation
		/// </summary>
		Invalid_ABORh_typing_and_interpretation = 28,
		/// <summary>
		/// Previously_recorded_results_inactivated
		/// </summary>
		Previously_recorded_results_inactivated = 29,
		/// <summary>
		/// QC_not_performed_on_rack_used_for_testing
		/// </summary>
		QC_not_performed_on_rack_used_for_testing = 30,
		/// <summary>
		/// ABORh_discrepancy
		/// </summary>
		ABORh_discrepancy = 31,
		/// <summary>
		/// Discrepant_patient_antigen_typing
		/// </summary>
		Discrepant_patient_antigen_typing = 32,
		/// <summary>
		/// Emergency_issue_request
		/// </summary>
		Emergency_issue_request = 34,
		/// <summary>
		/// Antigen_testing_phase_change
		/// </summary>
		Antigen_testing_phase_change = 36,
		/// <summary>
		/// Previously_recorded_antigen_results_invalidated
		/// </summary>
		Previously_recorded_antigen_results_invalidated = 37,
		/// <summary>
		/// CautionTag_BTRF_expired_specimen
		/// </summary>
		CautionTag_BTRF_expired_specimen = 38,
		/// <summary>
		/// CautionTag_BTRF_expired_unit
		/// </summary>
		CautionTag_BTRF_expired_unit = 39,
		/// <summary>
		/// CautionTag_BTRF_antigen_neg_reqs_not_met
		/// </summary>
		CautionTag_BTRF_antigen_neg_reqs_not_met = 40,
		/// <summary>
		/// CautionTag_BTRF_antigen_component_reqs_not_met
		/// </summary>
		CautionTag_BTRF_component_reqs_not_met = 41,
		/// <summary>
		/// Unit_ER_issued_testing_problem
		/// </summary>
		Unit_ER_issued_testing_problem = 42,
		/// <summary>
		/// Unit_out_of_controlled_storage_for_30_minutes   
		/// </summary>
		Unit_out_of_controlled_storage_for_30_minutes = 43,
		/// <summary>
		/// Unit_unsatisfactory_upon_return    
		/// </summary>
		Unit_unsatisfactory_upon_return = 44,
		/// <summary>
		/// ABO_incompatible_unit_transfused    
		/// </summary>
		ABO_incompatible_unit_transfused = 45,
		/// <summary>
		/// Release_patient_restriction
		/// </summary>
		Release_patient_restriction = 46,
		/// <summary>
		/// Unit_issued_on_expired_specimen
		/// </summary>
		Unit_issued_on_expired_specimen = 47,
		/// <summary>
		/// Issued_expired_unit
		/// </summary>
		Issued_expired_unit = 48,
		/// <summary>
		/// Antigen_positive_untested_units_issued
		/// </summary>
		Antigen_positive_untested_units_issued = 49,
		/// <summary>
		/// Less_restrictive_unit_issued
		/// </summary>
		Less_restrictive_unit_issued = 50,
		/// <summary>
		/// Unit_issued_with_unsatisfied_transfusion_requirement
		/// </summary>
		Unit_issued_with_unsatisfied_transfusion_requirement = 51,
		/// <summary>
		/// Biohazardous_unit_issued
		/// </summary>
		Biohazardous_unit_issued = 52,
		/// <summary>
		/// Emergency_issue_required_testing_incomplete
		/// </summary>
		Emergency_issue_required_testing_incomplete = 53,
		/// <summary>
		/// ABO_discrepant_unit_issued
		/// </summary>
		ABO_discrepant_unit_issued = 54,
		/// <summary>
		/// Transfusion_Reaction_Workup
		/// </summary>
		Transfusion_Reaction_Workup = 57,
		/// <summary>
		/// Expired_task_processed
		/// </summary>
		Expired_task_processed = 58,
		/// <summary>
		/// ExpiredSupply_UnitModification
		/// </summary>
		Expired_Supply_UnitModification = 59,
		/// <summary>
		/// Final_unit_status_removed
		/// </summary>
		Final_unit_status_removed = 60,
		/// <summary>
		/// Selected_expired_unit
		/// </summary>
		Selected_expired_unit = 61,
		/// <summary>
		/// Less_restrictive_unit_selected
		/// </summary>
		Less_restrictive_unit_selected = 62,
		/// <summary>
		/// Inconclusive_crossmatch
		/// </summary>
		Inconclusive_crossmatch = 63,
		/// <summary>
		/// Electronic_Transfusion_Record_Update
		/// </summary>
		Electronic_Transfusion_Record_Update = 64, 
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown = 999,
		/// <summary>
		/// Do not issue!  This is a semi-hack required for U73, Issue unit.
		/// </summary>
		Unissuable = 1000
	}
	/// <summary>
	/// OrderAlertTypeCode
	/// </summary>
	public enum OrderAlertTypeCode
	{
		/// <summary>
		/// All_orders
		/// </summary>
		All_orders = 0,
		/// <summary>
		/// Hour_limit
		/// </summary>
		Hour_limit = 1,
		/// <summary>
		/// Specimen_OK_or_NA
		/// </summary>
		Specimen_OK_or_NA = 2,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown = 3
	}

	/// <summary>
	/// ConnectionType
	/// </summary>
	public enum ConnectionType
	{
		/// <summary>
		/// VBECS
		/// </summary>
		VBECS,
		/// <summary>
		/// InterfaceDB
		/// </summary>
		InterfaceDB,
		/// <summary>
		/// ConversionDB
		/// </summary>
		ConversionDB,
        /// <summary>
        /// SettingsReader (check to lookup target VNN)
        /// </summary>
        SettingsReader
	}

	/// <summary>
	/// Form printing
	/// </summary>
	public enum Print
	{
		/// <summary>
		/// Caution tag
		/// </summary>
		CautionTag = 0,
		/// <summary>
		/// Blood transfusion record form
		/// </summary>
		BTRF = 1,
		/// <summary>
		///  Both
		/// </summary>
		Both = 2
	}

	/// <summary>
	/// Patient Change Status
	/// </summary>
	public enum PatientChangeStatus
	{
		/// <summary>
		/// Error
		/// </summary>
		Error = 'E',
		/// <summary>
		/// In Process
		/// </summary>
		InProcess = 'I',
		/// <summary>
		/// Pending Processing
		/// </summary>
		PendingProcessing = 'P',
		/// <summary>
		/// Successfully Processed
		/// </summary>
		SuccessfullyProcessed = 'S',
		/// <summary>
		/// Inactive
		/// </summary>
		Inactive = 'X',
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	}

	/// <summary>
	/// Reagent Types
	/// </summary>
	public enum ReagentType
	{
		/// <summary>
		/// A2Cell
		/// </summary>
		A2Cell = 2,
		/// <summary>
		/// Anti-A
		/// </summary>
		AntiA = 48,
		/// <summary>
		/// Anti A,B
		/// </summary>
		AntiAB = 49,
		/// <summary>
		/// Anti-Complement
		/// </summary>
		AntiComplement = 51,
		/// <summary>
		/// Anti-D
		/// </summary>
		AntiD = 52,
		/// <summary>
		/// Anti-IgG
		/// </summary>
		AntiIgG = 54,
		/// <summary>
		/// ComplementCheckCell
		/// </summary>
		ComplementCheckCell = 55,
		/// <summary>
		/// CC
		/// </summary>
		CC = 56,
		/// <summary>
		/// PS AHG
		/// </summary>
		PSAHG = 59,
		/// <summary>
		/// ReverseABOTypingCells
		/// </summary>
		ReverseABO = 62,
		/// <summary>
		/// ScreeningCells
		/// </summary>
		ScreeningCells = 63,
		/// <summary>
		/// CellPanel
		/// </summary>
		CellPanel = 67,
		/// <summary>
		/// Other Set
		/// </summary>
		OtherSet = 71
	}

	/// <summary>
	/// Daylight savings scheme used in VAMC division. 
	/// </summary>
	public enum DaylightSavingsType
	{
		/// <summary>
		/// Do not observe DST.
		/// </summary>
		DoNotObserve = 1,
		/// <summary>
		/// USA standard DST.
		/// </summary>
		UsaStandard = 2,
		/// <summary>
		/// Custom DST.
		/// </summary>
		Custom = 3,
		/// <summary>
		/// Unknown.
		/// </summary>
		Unknown = 4
	}

	/// <summary>
	/// SupplyInventoryReportFilter - used to distinguish which type of filter to use
	/// </summary>
	public enum SupplyInventoryReportFilter
	{
		/// <summary>
		/// InDate
		/// </summary>
		InDate,
		/// <summary>
		/// UnSatisfactory
		/// </summary>
		Unsatisfactory,
		/// <summary>
		/// Expired
		/// </summary>
		Expired,
		/// <summary>
		/// ExpiredWithDateRange
		/// </summary>
		ExpiredWithDateRange
	}

	/// <summary>
	/// Indicates where the patient ABO/Rh is coming from
	/// </summary>
	public enum ABORhSource
	{
		/// <summary>
		/// From a valid specimen test
		/// </summary>
		SpecimenTest = 0,
		/// <summary>
		/// From the previous specimen test because the most recent 
		/// one is discrepant and not justified
		/// </summary>
		SpecimenTestDiscrepancy = 1,
		/// <summary>
		/// From the conversion
		/// </summary>
		Conversion = 2,
		/// <summary>
		/// From the conversion because the most recent specimen test 
		/// is discrepant and has not been justified
		/// </summary>
		ConversionDiscrepancy = 3,
		/// <summary>
		/// No results on file
		/// </summary>
		None = 4
	}

	/// <summary>
	/// PatientTransfusionCommentCategoryCode
	/// </summary>
	public enum PatientTransfusionCommentCategoryCode
	{
		/// <summary>
		/// PreTransfusionSpecimenChecks
		/// </summary>
		PreTransfusionSpecimenChecks = 1,
		/// <summary>
		///  PostTransfusionSpecimenChecks
		/// </summary>
		PostTransfusionSpecimenChecks = 2,
		/// <summary>
		///  ImplicatedUnits
		/// </summary>
		ImplicatedUnits= 3,
		/// <summary>
		///  SymptomDetails
		/// </summary>
		SymptomDetails = 4
	}

	/// <summary>
	/// PatientTransfusionPartialSaveId
	/// </summary>
	public enum PatientTransfusionPartialSaveId
	{
		/// <summary>
		/// NoDataSaved
		/// </summary>
		NoDataSaved = 0,
		/// <summary>
		/// SpecimenChecksComplete
		/// </summary>
		SpecimenChecksComplete = 1,
		/// <summary>
		/// ImplicatedUnitsComplete
		/// </summary>
		ImplicatedUnitsComplete = 2,
		/// <summary>
		/// SymptomsComplete
		/// </summary>
		SymptomsComplete = 3,
		/// <summary>
		/// SerologicTestsComplete
		/// </summary>
		SerologicTestsComplete = 4,
		/// <summary>
		/// ReportFinalized
		/// </summary>
		ReportFinalized = 5
	}

	/// <summary>
	/// Used to indicate the consistency (or lack of) of ABO/Rh typing
	/// </summary>
	public enum TypingTestResults
	{
		/// <summary>
		/// Match
		/// </summary>
		Match = 0,
		/// <summary>
		/// Discrepancy
		/// </summary>
		Discrepancy = 1,
		/// <summary>
		/// NoResults
		/// </summary>
		NoResults = 2
	}

	/// <summary>
	/// Defines different sections of the Cost Accounting Report
	/// </summary>
	public enum CostAccountingReportSections
	{
		/// <summary>
		/// IncomingShipment
		/// </summary>
		IncomingShipment,
		/// <summary>
		/// OutgoingShipment
		/// </summary>
		OutgoingShipment,
		/// <summary>
		/// Modifications
		/// </summary>
		Modifications,
		/// <summary>
		/// OffSiteABID
		/// </summary>
		OffSiteABID,
		/// <summary>
		/// DiscardedUnits
		/// </summary>
		DiscardedUnits,
		/// <summary>
		/// Main
		/// </summary>
		Main,
		/// <summary>
		/// InactivatedUnits
		/// </summary>
		InactivatedUnits,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	}

	/// <summary>
	/// Type of Division Transfusion Report
	/// </summary>
	public enum TransfusionReportType
	{
		/// <summary>
		/// TreatingSpecialty
		/// </summary>
		TreatingSpecialty,
		/// <summary>
		/// IssueToLocation
		/// </summary>
		IssueToLocation,
		/// <summary>
		/// Physician
		/// </summary>
		Physician,
		/// <summary>
		/// Unknown
		/// </summary>
		Unknown
	}

	/// <summary>
	/// Sort order in prolonged transfusion time report.
	/// </summary>
	public enum ProlongedTransfusionTimeReportSortOrder : int
	{
		/// <summary>
		/// ReversheChronological
		/// </summary>
		ReverseChronological = 0,
		/// <summary>
		/// IssueToLocation
		/// </summary>			
		IssueToLocation = 1
	}

	/// <summary>
	/// ThresholdType
	/// </summary>
	public enum ThresholdType
	{
		/// <summary>
		/// None
		/// </summary>
		None,
		/// <summary>
		/// Numeric
		/// </summary>
		Numeric,
		/// <summary>
		/// Text
		/// </summary>
		Text
	}

	/// <summary>
	/// AcceptOrderStatus
	/// </summary>
	public enum AcceptOrderStatus
	{
		/// <summary>
		/// Order can be accepted
		/// </summary>
		ReadyForAcceptance,
		/// <summary>
		/// Order needs a specimen association
		/// </summary>
		RequiresSpecimen,
		/// <summary>
		/// Order not accessioned
		/// </summary>
		NotAccessioned,
		/// <summary>
		/// Order is accepted
		/// </summary>
		AlreadyAcceptedOrRejected,
		/// <summary>
		/// Order is rejected
		/// </summary>
		AlreadyRejected,
		/// <summary>
		/// Specimen isn't in VBECS
		/// </summary>
		SpecimenNotInVBECS,
		/// <summary>
		/// SpecimenAlreadyInVBECS
		/// </summary>
		SpecimenAlreadyInVBECS,
		/// <summary>
		/// NoLabDataForSpecimen
		/// </summary>
		NoLabDataForSpecimen,
		/// <summary>
		/// SpecimenUidInvalid
		/// </summary>
		SpecimenUidInvalid,
		/// <summary>
		/// SpecimenMismatch
		/// </summary>
		SpecimenMismatch,
		/// <summary>
		/// Specimen associated with someone else
		/// </summary>
		WrongSpecimen,
		/// <summary>
		/// Specimen isn't maintainable
		/// </summary>
        SpecimenNotMaintainable,
		/// <summary>
		/// SpecimenRequiresUpdate
		/// </summary>
		SpecimenRequiresUpdate,
		/// <summary>
		/// SpecimenHasBrokenRules
		/// </summary>
		SpecimenHasBrokenRules,
		/// <summary>
		/// Order has not been selected
		/// </summary>
		None
	}

	/// <summary>
	/// Used by Blood Unit Selector Vertical 
	/// to return units that meet additional
	/// criteria.  For example, also bring 
	/// back units in final status.  
	/// </summary>
	public enum AdditionalBloodUnitSearchCriteria
	{
		/// <summary>
		/// None
		/// </summary>
		None = 0,
		/// <summary>
		/// UnitsInFinalStatus
		/// </summary>
		UnitsInFinalStatus = 1,
		/// <summary>
		/// InactiveUnits
		/// </summary>
		InactiveUnits = 2
	}

	/// <summary>
	/// HL7 interface names.
	/// </summary>
	public enum InterfaceName
	{
		/// <summary>
		/// CPRS
		/// </summary>
		CPRS = 1,
		/// <summary>
		/// Patient Update
		/// </summary>
		Patient_Update = 2,
		/// <summary>
		/// Patient Merge
		/// </summary>
		Patient_Merge = 3,
		/// <summary>
		/// BCE COTS
		/// </summary>
		BCE_COTS = 4,
		/// <summary>
		/// Auto_Instrument
		/// </summary>
        Auto_Instrument = 5
	}

	/// <summary>
	/// Message statuses for HL7 message log inserts.
	/// </summary>
	public enum MessageStatus
	{
		/// <summary>
		/// Pending Transmission = 1
		/// </summary>
		PendingTransmission = 1,
		/// <summary>
		/// General Transmission Error = 2
		/// </summary>
		GeneralTransmissionError = 2,
		/// <summary>
		/// Successfully Completed = 3
		/// </summary>
		SuccessfullyCompleted = 3,
		/// <summary>
		/// Awaiting Response = 4
		/// </summary>
		AwaitingResponse = 4,
		/// <summary>
		/// Invalid Message Format = 5
		/// </summary>
		InvalidMessageFormat = 5,
		/// <summary>
		/// Processing Error = 6
		/// </summary>
		ProcessingError = 6,
		/// <summary>
		/// Processing Incoming Message
		/// </summary>
		ProcessingIncomingMessage = 7
	}

	/// <summary>
	/// Grid navigation direction
	/// </summary>
	public enum GridDirection
	{
		/// <summary>
		/// Up
		/// </summary>
		Up,
		/// <summary>
		/// Down
		/// </summary>
		Down,
		/// <summary>
		/// Left
		/// </summary>
		Left,
		/// <summary>
		/// Right
		/// </summary>
		Right
	}
    /// <summary>
    /// The application or project name associated with the configuration values in the VBECSGlobalConfig DB table
    /// </summary>
    public enum ApplicationNameGlobalConfig
    {
        /// <summary>
        ///Vbecs
        /// </summary>
        Vbecs,
        /// <summary>
        /// Vbecs Admin 
        /// </summary>
        VbecsAdmin,
        /// <summary>
        /// VistALink Listener
        /// </summary>
        VistalinkListener,
        /// <summary>
        /// ReportScheduler
        /// </summary>
        ReportScheduler,
        /// <summary>
        /// HL7Service - use to be Multilistener
        /// </summary>
        HL7Service,
        /// <summary>
        /// HL7Client
        /// </summary>
        HL7Client,
        /// <summary>
        /// VistaLinkService
        /// </summary>
        VistaLinkService // CR 3419
    }

	/// <summary>
	/// HL7BPDispenseStatus
	/// CR 2959
	/// </summary>
	public enum HL7BPDispenseStatus
	{
		/// <summary>
		/// Dispensed to patient location 
		/// </summary>
		DS,
		/// <summary>
		/// Released - no longer allocated to patient 
		/// </summary>
		RE,
		/// <summary>
		/// Reserved - ordered and product allocated for patient 
		/// </summary>
		RS,
		/// <summary>
		/// Unknown 
		/// </summary>
		UK
	}

	/// <summary>
	/// InterfaceActiveStatus
	/// </summary>
	public enum InterfaceActiveStatus
	{
		/// <summary>
		/// Active 
		/// </summary>
		Active,
		/// <summary>
		/// Inactive - the interface has been deactivated 
		/// </summary>
		Inactive,
		/// <summary>
		/// Null/Not set
		/// </summary>
		NotSet
	}

	/// <summary>
	/// ApplicationOfRecordType
	/// </summary>
	public enum ApplicationOfRecordType
	{
		/// <summary>
		/// Null/Not set
		/// </summary>
		NotSet = 0,
		/// <summary>
		/// Active 
		/// </summary>
		VBECS = 1,
		/// <summary>
		/// Inactive - the interface has been deactivated 
		/// </summary>
		BCE_COTS = 2
	}

    /// <summary>
    /// PendingTestStatus
    /// </summary>
    public enum PendingTestStatus
    {
        /// <summary>
        /// Pending = 1
        /// </summary>
        Pending = 1,
        /// <summary>
        /// Accepted = 2
        /// </summary>
        Accepted = 2,
        /// <summary>
        /// Rejected = 3
        /// </summary>
        Rejected = 3
    };

    /// <summary>
    /// TestValidationStatus: Used to give a validation status to a pending blood unit record
    /// </summary>
    public enum TestValidationStatus
    {
        /// <summary>
        /// Unknown = 0
        /// </summary>
        Unknown = 0,
        /// <summary>
        /// Valid = 1
        /// </summary>
        Valid = 1,
        /// <summary>
        /// Warning = 2
        /// </summary>
        Warning = 2,
        /// <summary>
        /// Error = 3
        /// </summary>
        Error = 3
    }

    /// <summary>
    ///  Used to switch between blood tests in the AutoInstrumentHL7Paser
    /// </summary>
    public enum BloodTestPanelName
    {
        //TODO: Add summaries for theis
       /// <summary>
       ///Unit ABORh
       /// </summary>
       UnitABORh = 1,
       /// <summary>
       /// Patient ABORh
       /// </summary>
       PatientABORh = 2,
       /// <summary>
       /// Anigen Typing
       /// </summary>
       AnigenTyping = 3,
       /// <summary>
       /// WeakD
       /// </summary>
       WeakD = 4,
       /// <summary>
       /// WeakD
       /// </summary>
       TAS = 5,
       /// <summary>
       /// WeakD
       /// </summary>
       ABS = 6,
       /// <summary>
       /// WeakD
       /// </summary>
       DAT = 7,
       /// <summary>
       /// WeakD
       /// </summary>
       XM = 8
    }
}